/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.entities;

import AppliedIntegrations.Blocks.BlocksEnum;
import AppliedIntegrations.api.BlackHoleSystem.ISingularity;
import appeng.util.Platform;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySingularity
extends EntitySnowball {
    private final double startX;
    private final double startY;
    private final double startZ;
    private final BlocksEnum singularityBlock;
    private EntitySingularity linkedSingularity;
    private ISingularity bornTile;

    public EntitySingularity(World world, double x, double y, double z, BlocksEnum singularityBlock) {
        super(world, x, y, z);
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        if (!ISingularity.class.isAssignableFrom(singularityBlock.tileEnum.clazz)) {
            throw new IllegalStateException(String.format("Can't use %s as ISingularity", singularityBlock.tileEnum.clazz.getName()));
        }
        this.singularityBlock = singularityBlock;
    }

    public EntitySingularity(World hostWorld, BlockPos hostPos, BlocksEnum singularityType) {
        this(hostWorld, hostPos.func_177958_n(), hostPos.func_177956_o(), hostPos.func_177952_p(), singularityType);
    }

    public void setLinked(EntitySingularity singularity) {
        this.linkedSingularity = singularity;
    }

    public ISingularity getBornSingularity() {
        return this.bornTile;
    }

    protected void func_70184_a(RayTraceResult map) {
        TileEntity tile;
        if (this.startX == this.field_70165_t && this.startY == this.field_70163_u && this.startZ == this.field_70161_v) {
            return;
        }
        this.field_70170_p.func_175656_a(map.func_178782_a(), this.singularityBlock.b.func_176223_P());
        if (Platform.isServer()) {
            this.func_70106_y();
        }
        if ((tile = this.field_70170_p.func_175625_s(map.func_178782_a())) instanceof ISingularity) {
            this.bornTile = (ISingularity)tile;
            ((ISingularity)tile).setEntangledHoleEntity(this.linkedSingularity);
        }
    }
}

