/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile;

import AppliedIntegrations.Container.part.ContainerEnergyInterface;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Helpers.EnergyInterfaceDuality;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Parts.IEnergyMachine;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.EnergyInterfaceStorage;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.api.IInventoryHost;
import AppliedIntegrations.api.INBTStorage;
import AppliedIntegrations.api.JouleInterfaceStorage;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import AppliedIntegrations.tile.AITile;
import appeng.api.config.Actionable;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.networking.IGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.INetworkToolAgent;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;

public class TileEnergyInterface
extends AITile
implements IEnergyMachine,
INetworkToolAgent,
IEnergyInterface,
IStorageMonitorable,
IInventoryHost {
    private static final String NBT_KEY_ENERGY_TAG = "#ENERGY_SUB_TAG";
    private static final String NBT_KEY_BAR_TAG = "#BAR_SUB_TAG";
    public static int capacity = 100000;
    private LinkedHashMap<AEPartLocation, EnergyInterfaceStorage> RFStorage = new LinkedHashMap();
    private LinkedHashMap<AEPartLocation, EnergyInterfaceStorage> EUStorage = new LinkedHashMap();
    private LinkedHashMap<AEPartLocation, JouleInterfaceStorage> JOStorage = new LinkedHashMap();
    private LinkedHashMap<AEPartLocation, LiquidAIEnergy> filteredEnergies = new LinkedHashMap();
    private LinkedHashMap<AEPartLocation, LiquidAIEnergy> barMap = new LinkedHashMap();
    private List<ContainerEnergyInterface> containers = new ArrayList<ContainerEnergyInterface>();
    private EnergyInterfaceDuality duality = new EnergyInterfaceDuality(this);
    private boolean updateRequested;
    private AIGridNodeInventory upgradeInventory = new AIGridNodeInventory("", 1, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return 1.validateStack(itemStack);
        }
    };

    public TileEnergyInterface() {
        for (AEPartLocation dir : AEPartLocation.SIDE_LOCATIONS) {
            this.duality.initStorage(dir);
        }
    }

    public int x() {
        return this.field_174879_c.func_177958_n();
    }

    public int y() {
        return this.field_174879_c.func_177956_o();
    }

    public int z() {
        return this.field_174879_c.func_177952_p();
    }

    public void addListener(ContainerEnergyInterface container) {
        if (!this.containers.contains(container)) {
            this.containers.add(container);
        }
    }

    public void onActivate(EntityPlayer player, AEPartLocation side) {
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiInterface, player, this.getHostSide(), this.func_174877_v());
            this.updateRequested = true;
        }
    }

    public AIGridNodeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            NBTTagCompound energyTag = nbt.func_74775_l(NBT_KEY_ENERGY_TAG + side.name());
            int energyIndex = energyTag.func_74762_e("#AIEnergy");
            if (energyIndex == -1) {
                this.filteredEnergies.put(side, null);
            } else {
                this.filteredEnergies.put(side, LiquidAIEnergy.readFromNBT(energyTag));
            }
            NBTTagCompound barTag = nbt.func_74775_l(NBT_KEY_ENERGY_TAG + side.name());
            int barIndex = barTag.func_74762_e("#AIEnergy");
            if (barIndex == -1) {
                this.filteredEnergies.put(side, null);
            } else {
                this.filteredEnergies.put(side, LiquidAIEnergy.readFromNBT(barTag));
            }
            for (LiquidAIEnergy next : LiquidAIEnergy.energies.values()) {
                NBTTagCompound storageTag = nbt.func_74775_l(NBT_KEY_ENERGY_TAG + side.name() + next.getEnergyName());
                IInterfaceStorageDuality storage = this.getEnergyStorage(next, side);
                if (!(storage instanceof INBTStorage)) continue;
                INBTStorage inbtStorage = (INBTStorage)((Object)storage);
                inbtStorage.readFromNBT(storageTag);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            NBTTagCompound energyTag = new NBTTagCompound();
            LiquidAIEnergy energy = this.filteredEnergies.get(side);
            if (energy != null) {
                energy.writeToNBT(energyTag);
            } else {
                energyTag.func_74768_a("#AIEnergy", -1);
            }
            nbt.func_74782_a(NBT_KEY_ENERGY_TAG + side.name(), (NBTBase)energyTag);
            NBTTagCompound barTag = new NBTTagCompound();
            LiquidAIEnergy bar = this.barMap.get(side);
            if (bar != null) {
                bar.writeToNBT(barTag);
            } else {
                barTag.func_74768_a("#AIEnergy", -1);
            }
            nbt.func_74782_a(NBT_KEY_BAR_TAG + side.name(), (NBTBase)barTag);
            for (LiquidAIEnergy next : LiquidAIEnergy.energies.values()) {
                NBTTagCompound storageTag = new NBTTagCompound();
                IInterfaceStorageDuality storage = this.getEnergyStorage(next, side);
                if (storage instanceof INBTStorage) {
                    INBTStorage inbtStorage = (INBTStorage)((Object)storage);
                    inbtStorage.writeToNBT(storageTag);
                }
                nbt.func_74782_a(NBT_KEY_ENERGY_TAG + side.name() + next.getEnergyName(), (NBTBase)storageTag);
            }
        }
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.duality.hasCapability(capability);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return this.duality.getCapability(capability, AEPartLocation.fromFacing((EnumFacing)facing));
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    public double getMaxTransfer(AEPartLocation side) {
        return (double)capacity / 2.0;
    }

    @Override
    public LiquidAIEnergy getFilteredEnergy(AEPartLocation side) {
        return this.filteredEnergies.get(side);
    }

    @Override
    public IInterfaceStorageDuality getEnergyStorage(LiquidAIEnergy energy, AEPartLocation side) {
        if (energy == AIEnergy.RF) {
            return this.RFStorage.get(side);
        }
        if (energy == AIEnergy.EU) {
            return this.EUStorage.get(side);
        }
        if (energy == AIEnergy.J) {
            return this.JOStorage.get(side);
        }
        return null;
    }

    @Override
    public void doInjectDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        this.duality.doInjectDualityWork(action);
    }

    @Override
    public void doExtractDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        this.duality.doExtractDualityWork(action);
    }

    @Override
    public void initEnergyStorage(LiquidAIEnergy energy, AEPartLocation side) {
        if (energy == AIEnergy.RF) {
            this.RFStorage.put(side, new EnergyInterfaceStorage(this, side, energy, capacity, capacity / 2));
        }
        if (energy == AIEnergy.EU) {
            this.EUStorage.put(side, new EnergyInterfaceStorage(this, side, energy, (int)((double)capacity * 0.25), capacity * 2));
        }
        if (energy == AIEnergy.J) {
            this.JOStorage.put(side, new JouleInterfaceStorage(this, side, capacity * 2));
        }
    }

    @Override
    public int getMaxEnergyStored(AEPartLocation side, LiquidAIEnergy linkedMetric) {
        if (this.getEnergyStorage(linkedMetric, side) == null) {
            return 0;
        }
        Object num = this.getEnergyStorage(linkedMetric, side).getMaxStored();
        if (num == null) {
            return 0;
        }
        return ((Number)num).intValue();
    }

    @Override
    public TileEntity getFacingTile(EnumFacing side) {
        return null;
    }

    @Override
    public List<ContainerEnergyInterface> getListeners() {
        return this.containers;
    }

    @Override
    public void setLastInjectedEnergy(AEPartLocation side, LiquidAIEnergy energy) {
        this.barMap.put(side, energy);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        for (AEPartLocation side : AEPartLocation.values()) {
            if (this.barMap.get(side) == null) continue;
            this.duality.notifyListenersOfEnergyBarChange(this.barMap.get(side), side);
            this.duality.notifyListenersOfBarFilterChange(this.barMap.get(side));
        }
        try {
            if (this.getGridNode() == null) {
                return;
            }
            if (this.getGridNode().isActive()) {
                this.doInjectDualityWork(Actionable.MODULATE);
                this.doExtractDualityWork(Actionable.MODULATE);
            }
        }
        catch (NullNodeConnectionException | GridAccessException e) {
            AILog.error(e, "Node of Tile Energy Interface, when it's active could not be null.. But it is", new Object[0]);
        }
    }

    @Override
    public void updateFilter(LiquidAIEnergy energyInArray, int index) {
        this.filteredEnergies.put(AEPartLocation.fromOrdinal((int)index), energyInArray);
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> iStorageChannel) {
        if (this.getGridNode(AEPartLocation.INTERNAL) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(AEPartLocation.INTERNAL).getGrid();
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        return storage.getInventory(iStorageChannel);
    }

    public boolean showNetworkInfo(RayTraceResult rayTraceResult) {
        return false;
    }
}

