/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController;

import AppliedIntegrations.Container.tile.MultiController.ContainerMultiControllerCore;
import AppliedIntegrations.Container.tile.MultiController.ContainerMultiControllerTerminal;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Inventory.AIGridNodeInventoryWithView;
import AppliedIntegrations.Items.NetworkCard;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.MultiController.PacketScrollClientToServer;
import AppliedIntegrations.Utils.MultiBlockUtils;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.IInventoryHost;
import AppliedIntegrations.api.Multiblocks.IAIPatternExtendable;
import AppliedIntegrations.tile.AITile;
import AppliedIntegrations.tile.IAIMultiBlock;
import AppliedIntegrations.tile.IMaster;
import AppliedIntegrations.tile.MultiController.AIMultiControllerTile;
import AppliedIntegrations.tile.MultiController.Networking.MEMultiControllerMonitorHandlerReceiver;
import AppliedIntegrations.tile.MultiController.TileMultiControllerHousing;
import AppliedIntegrations.tile.MultiController.TileMultiControllerPort;
import AppliedIntegrations.tile.MultiController.TileMultiControllerRib;
import AppliedIntegrations.tile.MultiController.helpers.Crafting.MultiControllerCPUHandler;
import AppliedIntegrations.tile.MultiController.helpers.Crafting.MultiControllerCraftingHandler;
import AppliedIntegrations.tile.MultiController.helpers.Matter.FilteredMultiControllerPortHandler;
import AppliedIntegrations.tile.MultiController.helpers.MultiControllerCoreInventory;
import AppliedIntegrations.tile.Patterns.AIPatterns;
import appeng.api.config.IncludeExclude;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.INetworkToolAgent;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class TileMultiControllerCore
extends AITile
implements IAIMultiBlock,
IMaster,
INetworkToolAgent,
ITickable,
ITerminalHost,
IConfigManagerHost {
    public static final int INV_SLOTS = 153;
    private static final String KEY_FORMED = "#FORMED";
    private boolean constructionRequested;
    private List<AIMultiControllerTile> slaves = new ArrayList<AIMultiControllerTile>();
    private LinkedHashMap<Class<? extends AIMultiControllerTile>, List<AIMultiControllerTile>> slaveMap = new LinkedHashMap();
    private MultiControllerCoreInventory cardInventory = new MultiControllerCoreInventory(this);
    private IMEMonitor<IAEItemStack> monitor = new MEMonitorHandler((IMEInventoryHandler)this.cardInventory);
    private CardInventoryManager cardManager = new CardInventoryManager();
    private IConfigManager configManager = new ConfigManager((IConfigManagerHost)this);
    private List<Class<? extends AIMultiControllerTile>> multi_controllerClasses = Arrays.asList(TileMultiControllerHousing.class, TileMultiControllerPort.class, TileMultiControllerRib.class);
    private LinkedHashMap<AEPartLocation, Map<Integer, TileMultiControllerPort>> portMap = new LinkedHashMap<AEPartLocation, Map<Integer, TileMultiControllerPort>>(){
        {
            for (AEPartLocation side : AEPartLocation.values()) {
                this.put(side, new HashMap());
            }
        }
    };
    private LinkedHashMap<AEPartLocation, Map<Integer, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IMEInventoryHandler>>> portHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IMEInventoryHandler>>>(){
        {
            for (AEPartLocation side : AEPartLocation.values()) {
                this.put(side, new HashMap());
            }
        }
    };
    private LinkedHashMap<AEPartLocation, Map<Integer, ICraftingProvider>> portCraftingHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, ICraftingProvider>>(){
        {
            for (AEPartLocation side : AEPartLocation.values()) {
                this.put(side, new HashMap());
            }
        }
    };
    private LinkedHashMap<AEPartLocation, Map<Integer, MultiControllerCPUHandler>> portCPUHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, MultiControllerCPUHandler>>(){
        {
            for (AEPartLocation side : AEPartLocation.values()) {
                this.put(side, new HashMap());
            }
        }
    };
    public AIGridNodeInventoryWithView cardInv = new AIGridNodeInventoryWithView("Network Card Slots", 153, 45, 1, this.cardManager){

        @Override
        public ItemStack func_70298_a(int slotId, int amount) {
            if (this.slots[slotId].func_77973_b() instanceof NetworkCard) {
                TileMultiControllerCore.this.cardManager.onCardRemove(this.slots[slotId]);
            }
            return super.func_70298_a(slotId, amount);
        }

        @Override
        public boolean func_94041_b(int i, ItemStack itemstack) {
            return itemstack.func_77973_b() instanceof NetworkCard;
        }
    };
    private List<MEMultiControllerMonitorHandlerReceiver> receiverList = new ArrayList<MEMultiControllerMonitorHandlerReceiver>();
    private boolean isFormed;
    private int slotDifference;
    public List<ContainerMultiControllerCore> listeners = new ArrayList<ContainerMultiControllerCore>();

    public TileMultiControllerCore() {
        this.nullifyMap();
        this.configManager.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.configManager.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.configManager.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
    }

    public int getSlotDiff() {
        return this.slotDifference;
    }

    public void setSlotDiff(int scroll) {
        this.slotDifference = scroll;
        this.cardInv.updateView(scroll);
        if (this.field_145850_b.field_72995_K) {
            NetworkHandler.sendToServer(new PacketScrollClientToServer(this.getSlotDiff(), this));
        }
    }

    public CardInventoryManager getCardManager() {
        return this.cardManager;
    }

    private void cpuUpdate() {
    }

    public ICraftingGrid getMainNetworkCraftingGrid() {
        if (this.getMainNetwork() == null) {
            return null;
        }
        return (ICraftingGrid)this.getMainNetwork().getCache(ICraftingGrid.class);
    }

    private IGrid getMainNetwork() {
        if (!this.isFormed) {
            return null;
        }
        if (this.slaveMap.get(TileMultiControllerRib.class).isEmpty()) {
            return null;
        }
        TileMultiControllerRib rib = (TileMultiControllerRib)this.slaveMap.get(TileMultiControllerRib.class).get(0);
        return rib.getMainNetwork();
    }

    public void activate(EntityPlayer p) {
        AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiServerStorage, p, AEPartLocation.INTERNAL, this.field_174879_c);
    }

    public void postNetworkCellEvents() throws GridAccessException {
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            for (int portID = 0; portID < this.portMap.get(side).size(); ++portID) {
                if (this.portMap.get(side).get(portID) == null || this.portMap.get(side).get(portID).requestNetwork() == null) continue;
                this.postCellInventoryEvent(this.portMap.get(side).get(portID).requestNetwork());
                this.postGridEvent((MENetworkEvent)new MENetworkCraftingPatternChange(this.portCraftingHandlers.get(side).get(portID), this.getGridNode()));
            }
        }
        this.postCellInventoryEvent();
    }

    public void postNetworkAlterationsEvents(IStorageChannel<? extends IAEStack<?>> channel, Iterable change, MachineSource machineSource) throws GridAccessException {
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            for (int portID = 0; portID < this.portMap.get(side).size(); ++portID) {
                if (this.portMap.get(side).get(portID) == null || this.portMap.get(side).get(portID).requestNetwork() == null) continue;
                IStorageGrid grid = (IStorageGrid)this.portMap.get(side).get(portID).requestNetwork().getCache(IStorageGrid.class);
                grid.postAlterationOfStoredItems(channel, change, (IActionSource)machineSource);
            }
        }
    }

    public void providePortCrafting(ICraftingProviderHelper craftingTracker, AEPartLocation side, int portID) {
        if (this.portCraftingHandlers.get(side).get(portID) == null) {
            return;
        }
        this.portCraftingHandlers.get(side).get(portID).provideCrafting(craftingTracker);
    }

    public boolean pushPortPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table, AEPartLocation side, int portID) {
        if (this.portCraftingHandlers.get(side).get(portID) == null) {
            return false;
        }
        return this.portCraftingHandlers.get(side).get(portID).pushPattern(patternDetails, table);
    }

    public boolean isPortBusy(AEPartLocation side, int portID) {
        if (this.portCraftingHandlers.get(side).get(portID) == null) {
            return false;
        }
        return this.portCraftingHandlers.get(side).get(portID).isBusy();
    }

    public List<IMEInventoryHandler> getPortCellArray(AEPartLocation side, int portID, IStorageChannel<?> channel) {
        if (this.portHandlers.get(side) == null || this.portHandlers.get(side).get(portID) == null) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return Collections.singletonList(this.portHandlers.get(side).get(portID).get(channel));
    }

    public void savePortChanges(ICellInventory<?> iCellInventory, AEPartLocation side, int id) {
        TileMultiControllerPort port;
        if (iCellInventory != null) {
            iCellInventory.persist();
        }
        if ((port = this.getPortAtSide(id, side)) == null) {
            return;
        }
        this.func_145831_w().func_175646_b(port.func_174877_v(), (TileEntity)port);
    }

    private TileMultiControllerPort getPortAtSide(int id, AEPartLocation side) {
        for (IAIMultiBlock iAIMultiBlock : this.slaveMap.get(TileMultiControllerPort.class)) {
            TileMultiControllerPort port = (TileMultiControllerPort)iAIMultiBlock;
            if (port.getSideVector() != side || port.getPortID() != id) continue;
            return port;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.cardInv.readFromNBT(tag.func_150295_c("#cardInv", 10));
        if (tag.func_74767_n(KEY_FORMED)) {
            this.constructionRequested = true;
        }
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("#cardInv", (NBTBase)this.cardInv.writeToNBT());
        tag.func_74757_a(KEY_FORMED, this.isFormed);
        return super.func_189515_b(tag);
    }

    public boolean showNetworkInfo(RayTraceResult rayTraceResult) {
        return false;
    }

    @Override
    public Iterator<IGridNode> getMultiblockNodes() {
        return null;
    }

    @Override
    public void securityBreak() {
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.isFormed) {
            this.destroyMultiBlock();
        }
        Platform.spawnDrops((World)this.field_145850_b, (BlockPos)this.field_174879_c, Arrays.asList(this.cardInv.slots));
    }

    public void destroyMultiBlock() {
        for (AIMultiControllerTile tile : this.slaves) {
            tile.setMaster(null);
            tile.destroyProxyNode();
        }
        this.nullifyMap();
        this.slaves = new ArrayList<AIMultiControllerTile>();
        this.portMap = new LinkedHashMap<AEPartLocation, Map<Integer, TileMultiControllerPort>>(){
            {
                for (AEPartLocation side : AEPartLocation.values()) {
                    this.put(side, new HashMap());
                }
            }
        };
        this.portHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IMEInventoryHandler>>>(){
            {
                for (AEPartLocation side : AEPartLocation.values()) {
                    this.put(side, new HashMap());
                }
            }
        };
        this.portCraftingHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, ICraftingProvider>>(){
            {
                for (AEPartLocation side : AEPartLocation.values()) {
                    this.put(side, new HashMap());
                }
            }
        };
        this.portCPUHandlers = new LinkedHashMap<AEPartLocation, Map<Integer, MultiControllerCPUHandler>>(){
            {
                for (AEPartLocation side : AEPartLocation.values()) {
                    this.put(side, new HashMap());
                }
            }
        };
        this.isFormed = false;
        ContainerMultiControllerTerminal.channelList.forEach((Consumer<IStorageChannel<IAEStack<?>>>)((Consumer<IStorageChannel>)channel -> this.receiverList.forEach(meMultiControllerMonitorHandlerReceiver -> {
            if (this.getMainNetworkInventory((IStorageChannel)channel) != null) {
                this.getMainNetworkInventory((IStorageChannel)channel).removeListener((IMEMonitorHandlerReceiver)meMultiControllerMonitorHandlerReceiver);
            }
        })));
        this.receiverList = new ArrayList<MEMultiControllerMonitorHandlerReceiver>();
    }

    private void nullifyMap() {
        this.slaveMap = new LinkedHashMap();
        for (Class<? extends AIMultiControllerTile> type : this.multi_controllerClasses) {
            this.slaveMap.put(type, new ArrayList());
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.constructionRequested) {
            this.tryConstruct(null);
            this.constructionRequested = true;
        }
    }

    @Override
    public void notifyBlock() {
    }

    @Override
    public void tryConstruct(EntityPlayer p) {
        if (!this.isFormed) {
            AtomicInteger count = new AtomicInteger();
            LinkedHashMap<EnumFacing.Axis, Integer> axisLengthMap = new LinkedHashMap<EnumFacing.Axis, Integer>();
            int rangeToBlock = 0;
            while (rangeToBlock < 4) {
                int finalI = rangeToBlock++;
                Arrays.stream(EnumFacing.values()).filter(facing -> facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE).forEach(side -> {
                    TileEntity maybePort = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + side.func_82601_c() * finalI, this.func_174877_v().func_177956_o() + side.func_96559_d() * finalI, this.func_174877_v().func_177952_p() + side.func_82599_e() * finalI));
                    if (maybePort instanceof TileMultiControllerPort) {
                        axisLengthMap.put(side.func_176740_k(), finalI - 1);
                    }
                });
            }
            IAIPatternExtendable pattern = AIPatterns.ME_MULTI_CONTROLLER;
            if (axisLengthMap.size() != 3) {
                return;
            }
            pattern = MultiBlockUtils.getExtendedPattern(pattern, axisLengthMap);
            try {
                this.formServer(MultiBlockUtils.fillListWithPattern(pattern.getPatternData(), this, block -> count.getAndIncrement()), pattern, count, p);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void formServer(List<AIMultiControllerTile> toUpdate, IAIPatternExtendable pattern, AtomicInteger count, EntityPlayer p) throws GridAccessException {
        if (pattern.getPatternData().size() == count.get()) {
            for (AIMultiControllerTile slave : toUpdate) {
                if (slave == null) continue;
                slave.setMaster(this);
                slave.createProxyNode();
                this.slaveMap.get(slave.getClass()).add(slave);
                this.slaves.add(slave);
            }
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                List<BlockPos> edge = pattern.getPosEdgeMap().get(side);
                int edgePosId = 0;
                for (BlockPos pos : edge) {
                    TileEntity maybePort = this.func_145831_w().func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos));
                    if (!(maybePort instanceof TileMultiControllerPort)) continue;
                    TileMultiControllerPort port = (TileMultiControllerPort)maybePort;
                    port.setSideVector(side);
                    port.setPortID(edgePosId);
                    this.portMap.get(side).put(edgePosId, port);
                    ++edgePosId;
                }
            }
            this.cardManager.onInventoryChanged();
            this.postNetworkCellEvents();
            this.isFormed = true;
            ContainerMultiControllerTerminal.channelList.forEach((Consumer<IStorageChannel<IAEStack<?>>>)((Consumer<IStorageChannel>)channel -> {
                IMEMonitor inventory = this.getMainNetworkInventory((IStorageChannel)channel);
                MEMultiControllerMonitorHandlerReceiver receiver = new MEMultiControllerMonitorHandlerReceiver(this, (IStorageChannel<IAEStack<?>>)channel);
                this.receiverList.add(receiver);
                inventory.addListener(receiver, null);
            }));
            if (p != null) {
                p.func_145747_a((ITextComponent)new TextComponentTranslation("ME multi-controller formed!", new Object[0]));
            }
        }
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getMainNetworkInventory(IStorageChannel<T> channel) {
        if (this.getMainNetwork() == null) {
            return null;
        }
        return ((IStorageMonitorable)this.getMainNetwork().getCache(IStorageGrid.class)).getInventory(channel);
    }

    @Override
    public boolean hasMaster() {
        return true;
    }

    @Override
    public IMaster getMaster() {
        return this;
    }

    @Override
    public void setMaster(IMaster tileServerCore) {
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == this.cardInventory.getChannel()) {
            return this.monitor;
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public class CardInventoryManager
    implements IInventoryHost {
        public void onCardRemove(ItemStack card) {
            NBTTagCompound tag = Platform.openNbtData((ItemStack)card);
            AEPartLocation side = AEPartLocation.values()[tag.func_74762_e("#NET_SIDE")];
            int id = tag.func_74762_e("#PORT_ID");
            TileMultiControllerPort port = TileMultiControllerCore.this.getPortAtSide(id, side);
            if (port == null) {
                return;
            }
            ((Map)TileMultiControllerCore.this.portHandlers.get(side)).put(id, null);
            ((Map)TileMultiControllerCore.this.portCraftingHandlers.get(side)).put(id, null);
            ((Map)TileMultiControllerCore.this.portCPUHandlers.get(side)).put(id, null);
            TileMultiControllerCore.this.cpuUpdate();
            port.postCellInventoryEvent();
            port.postGridEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)((Map)TileMultiControllerCore.this.portCraftingHandlers.get(side)).get(id), TileMultiControllerCore.this.getGridNode()));
        }

        @Override
        public void onInventoryChanged() {
            for (ItemStack stack : TileMultiControllerCore.this.cardInv.slots) {
                if (!(stack.func_77973_b() instanceof NetworkCard)) continue;
                NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
                Pair<LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>>, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>>> data = NetworkCard.decodeDataFromTag(tag);
                AEPartLocation side = AEPartLocation.values()[tag.func_74762_e("#NET_SIDE")];
                int id = tag.func_74762_e("#PORT_ID");
                TileMultiControllerPort port = TileMultiControllerCore.this.getPortAtSide(id, side);
                if (port == null) continue;
                LinkedHashMap handlers = new LinkedHashMap();
                ContainerMultiControllerTerminal.channelList.forEach((Consumer<IStorageChannel<IAEStack<?>>>)((Consumer<IStorageChannel>)channel -> {
                    try {
                        FilteredMultiControllerPortHandler handler = Objects.requireNonNull(AIApi.instance()).getHandlerFromChannel((IStorageChannel<? extends IAEStack<?>>)channel).newInstance(data.getLeft(), data.getRight(), TileMultiControllerCore.this);
                        handlers.put(channel, handler);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new IllegalStateException("Unexpected Error");
                    }
                }));
                ((Map)TileMultiControllerCore.this.portHandlers.get(side)).put(id, handlers);
                ((Map)TileMultiControllerCore.this.portCraftingHandlers.get(side)).put(id, new MultiControllerCraftingHandler((LinkedHashMap)data.getLeft(), (LinkedHashMap)data.getRight(), TileMultiControllerCore.this));
                ((Map)TileMultiControllerCore.this.portCPUHandlers.get(side)).put(id, new MultiControllerCPUHandler(TileMultiControllerCore.this));
                TileMultiControllerCore.this.cpuUpdate();
                port.postCellInventoryEvent();
                port.postGridEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)((Map)TileMultiControllerCore.this.portCraftingHandlers.get(side)).get(id), TileMultiControllerCore.this.getGridNode()));
                port.postGridEvent((MENetworkEvent)new MENetworkCraftingCpuChange(TileMultiControllerCore.this.getGridNode()));
            }
        }
    }
}

