/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController.Render;

import AppliedIntegrations.Client.AITileFullRenderer;
import AppliedIntegrations.tile.MultiController.TileMultiControllerRib;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class MultiControllerRibRenderer
extends AITileFullRenderer<TileMultiControllerRib> {
    private static final ResourceLocation side = new ResourceLocation("appliedintegrations", "textures/blocks/server_frame.png");
    private static final ResourceLocation directionalSide = new ResourceLocation("appliedintegrations", "textures/blocks/server_frame_alt_b.png");
    private static final ResourceLocation offSide = new ResourceLocation("appliedintegrations", "textures/blocks/server_frame_off.png");
    private static final ResourceLocation offDirectionalSide = new ResourceLocation("appliedintegrations", "textures/blocks/server_frame_off_a.png");
    private static final EnumFacing[] axisDirections = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP};
    private static LinkedHashMap<TileMultiControllerRib, EnumFacing.Axis> tileAxisMap = new LinkedHashMap();

    public void render(TileMultiControllerRib te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.prepareMatrix(x, y, z);
        GlStateManager.func_179140_f();
        this.setLightAmbient(te);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTileTexture(te);
        this.drawQuadWithUV(new float[][]{{0.5f, -0.5f, 0.5f}, {0.5f, 0.5f, 0.5f}, {0.5f, 0.5f, -0.5f}, {0.5f, -0.5f, -0.5f}}, this.translateAxisToUV(te, EnumFacing.EAST));
        this.drawQuadWithUV(new float[][]{{-0.5f, -0.5f, 0.5f}, {-0.5f, 0.5f, 0.5f}, {-0.5f, 0.5f, -0.5f}, {-0.5f, -0.5f, -0.5f}}, this.translateAxisToUV(te, EnumFacing.WEST));
        this.drawQuadWithUV(new float[][]{{0.5f, 0.5f, -0.5f}, {0.5f, 0.5f, 0.5f}, {-0.5f, 0.5f, 0.5f}, {-0.5f, 0.5f, -0.5f}}, this.translateAxisToUV(te, EnumFacing.UP));
        this.drawQuadWithUV(new float[][]{{0.5f, -0.5f, -0.5f}, {0.5f, -0.5f, 0.5f}, {-0.5f, -0.5f, 0.5f}, {-0.5f, -0.5f, -0.5f}}, this.translateAxisToUV(te, EnumFacing.DOWN));
        this.drawQuadWithUV(new float[][]{{0.5f, -0.5f, 0.5f}, {0.5f, 0.5f, 0.5f}, {-0.5f, 0.5f, 0.5f}, {-0.5f, -0.5f, 0.5f}}, this.translateAxisToUV(te, EnumFacing.SOUTH));
        this.drawQuadWithUV(new float[][]{{0.5f, -0.5f, -0.5f}, {0.5f, 0.5f, -0.5f}, {-0.5f, 0.5f, -0.5f}, {-0.5f, -0.5f, -0.5f}}, this.translateAxisToUV(te, EnumFacing.NORTH));
        GlStateManager.func_179145_e();
        this.pushMatrix(x, y, z);
    }

    private void bindTileTexture(TileMultiControllerRib te) {
        for (EnumFacing side : axisDirections) {
            if (te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(side)) instanceof TileMultiControllerRib) {
                if (te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(side.func_176734_d())) instanceof TileMultiControllerRib) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bindDirectionalTexture(te));
                    tileAxisMap.put(te, side.func_176740_k());
                    break;
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bindNondirectionalTexture(te));
                continue;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bindNondirectionalTexture(te));
        }
    }

    private float[][] translateAxisToUV(TileMultiControllerRib te, EnumFacing side) {
        EnumFacing.Axis axis = tileAxisMap.get(te);
        if (axis == null) {
            return defaultUV;
        }
        if (axis == EnumFacing.Axis.Y) {
            return this.caesarShift(defaultUV);
        }
        if (axis == EnumFacing.Axis.Z && side.func_176740_k() == EnumFacing.Axis.Y) {
            return this.caesarShift(defaultUV);
        }
        return defaultUV;
    }

    private ResourceLocation bindDirectionalTexture(TileMultiControllerRib te) {
        if (!te.isActive) {
            return offDirectionalSide;
        }
        return directionalSide;
    }

    private ResourceLocation bindNondirectionalTexture(TileMultiControllerRib te) {
        if (!te.isActive) {
            return offSide;
        }
        return side;
    }
}

