/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController;

import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import appeng.api.config.IncludeExclude;
import appeng.api.config.SecurityPermissions;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiControllerPortHandler<T extends IAEStack<T>> {
    protected final TileMultiControllerCore host;
    protected final LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>> filteredMatter;
    private final LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>> filterMode;

    public MultiControllerPortHandler(LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>> filteredMatter, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>> filterMode, TileMultiControllerCore tileMultiControllerCore) {
        this.filteredMatter = filteredMatter;
        this.filterMode = filterMode;
        this.host = tileMultiControllerCore;
    }

    protected boolean canInteract(T input, SecurityPermissions permissions) {
        AtomicBoolean canInteract = new AtomicBoolean(false);
        if (input == null) {
            return canInteract.get();
        }
        IStorageChannel channel = input.getChannel();
        IncludeExclude mode = this.filterMode.get(permissions).get(channel);
        canInteract.set(mode == IncludeExclude.BLACKLIST);
        return mode == IncludeExclude.WHITELIST == this.filteredMatter.get(permissions).get(channel).stream().anyMatch(arg_0 -> input.equals(arg_0));
    }
}

