/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid.Mana;

import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class AEManaStack
implements IAEManaStack,
Comparable<IAEManaStack> {
    private long stackSize;
    private long countRequestable;
    private boolean isCraftable;
    private int hash;

    public AEManaStack(int amount) {
        this.setStackSize(amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.hash = 0;
    }

    private AEManaStack(AEManaStack stack) {
        this.setStackSize(stack.getStackSize());
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.hash = stack.hash;
    }

    public static IAEManaStack fromPacket(ByteBuf buf) {
        return AEManaStack.fromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public static IAEManaStack fromNBT(NBTTagCompound t) {
        AEManaStack ae = new AEManaStack(t.func_74762_e("ManaAmount"));
        ae.setCountRequestable(t.func_74763_f("Req"));
        return ae;
    }

    public void add(IAEManaStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public IAEManaStack setStackSize(long l) {
        this.stackSize = l;
        return this;
    }

    public long getCountRequestable() {
        return this.countRequestable;
    }

    public IAEManaStack setCountRequestable(long l) {
        this.countRequestable = l;
        return this;
    }

    public boolean isCraftable() {
        return this.isCraftable;
    }

    public IAEManaStack setCraftable(boolean b) {
        this.isCraftable = b;
        return this;
    }

    public IAEManaStack reset() {
        this.setStackSize(0L);
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return this;
    }

    public boolean isMeaningful() {
        return this.getStackSize() != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    public void incStackSize(long l) {
        this.setStackSize(this.getStackSize() + l);
    }

    public void decStackSize(long l) {
        this.setStackSize(this.getStackSize() - l);
    }

    public void incCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() + l);
    }

    public void decCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() - l);
    }

    public void writeToNBT(NBTTagCompound t) {
        t.func_74774_a("Count", (byte)0);
        t.func_74768_a("ManaAmount", (int)this.getStackSize());
        t.func_74772_a("Req", this.getCountRequestable());
    }

    public boolean fuzzyComparison(IAEManaStack other, FuzzyMode mode) {
        return true;
    }

    public void writeToPacket(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IAEManaStack copy() {
        return new AEManaStack(this);
    }

    public IAEManaStack empty() {
        IAEManaStack copy = this.copy();
        copy.reset();
        return copy;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<IAEManaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        return null;
    }

    @Override
    public int compareTo(IAEManaStack o) {
        return 0;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj instanceof AEManaStack;
    }
}

