/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.P2P;

import AppliedIntegrations.api.AIApi;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AIPartP2PTunnel<T extends AIPartP2PTunnel<T>>
extends PartP2PTunnel<T> {
    private boolean isOutput;

    public AIPartP2PTunnel(ItemStack is) {
        super(is);
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    protected void setOutput(boolean newValue) {
        this.isOutput = newValue;
    }

    private boolean loadPart(ItemStack newType, EntityPlayer player, EnumHand hand, short freq) {
        this.getHost().removePart(this.getSide(), true);
        AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
        IPart newBus = this.getHost().getPart(dir);
        if (newBus instanceof AIPartP2PTunnel) {
            AIPartP2PTunnel newTunnel = (AIPartP2PTunnel)newBus;
            newTunnel.setOutput(true);
            newTunnel.onTunnelNetworkChange();
            try {
                P2PCache p2p = newTunnel.getProxy().getP2P();
                p2p.updateFreq((PartP2PTunnel)newTunnel, freq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public ItemStack getItemStack(PartItemStack type) {
        return super.getItemStack(type);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (this.getTile().func_145831_w().field_72995_K) {
            return true;
        }
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        ItemStack is = player.func_184586_b(hand);
        ItemStack newPart = Objects.requireNonNull(AIApi.instance()).getTunnelFromStack(is.func_77973_b());
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            IPart testPart;
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = mc.getData(is);
            ItemStack newType = new ItemStack(data);
            short freq = data.func_74765_d("freq");
            if (!newType.func_190926_b() && newType.func_77973_b() instanceof IPartItem && (testPart = ((IPartItem)newType.func_77973_b()).createPartFromItemStack(newType)) instanceof PartP2PTunnel && this.loadPart(newType, player, hand, freq)) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (newPart != null && !newPart.func_190926_b()) {
            short myFreq = this.getFrequency();
            this.loadPart(newPart, player, hand, myFreq);
            Platform.notifyBlocksOfNeighbors((World)this.getTile().func_145831_w(), (BlockPos)this.getTile().func_174877_v());
            return true;
        }
        return false;
    }

    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!is.func_190926_b() && is.func_77973_b() instanceof IMemoryCard) {
            if (Platform.isClient()) {
                return true;
            }
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = mc.getData(is);
            short storedFrequency = data.func_74765_d("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            try {
                if (needsNewFrequency) {
                    newFreq = this.getProxy().getP2P().newFrequency();
                }
                this.getProxy().getP2P().updateFreq((PartP2PTunnel)this, newFreq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            ItemStack p2pItem = this.getItemStack(PartItemStack.WRENCH);
            String type = p2pItem.func_77977_a();
            p2pItem.func_77955_b(data);
            data.func_74777_a("freq", this.getFrequency());
            AEColor[] colors = Platform.p2p().toColors(this.getFrequency());
            int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
            data.func_74783_a("colorCode", colorCode);
            mc.setMemoryCardContents(is, type + ".name", data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isOutput = data.func_74767_n("output");
    }
}

