/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Container.part.ContainerEnergyTerminal;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Helpers.Energy.StackCapabilityHelper;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketTerminalUpdate;
import AppliedIntegrations.Parts.AIRotatablePart;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.api.IEnumHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public class PartEnergyTerminal
extends AIRotatablePart
implements ITerminalHost,
IConfigManagerHost,
IGridTickable,
IMEMonitorHandlerReceiver<IAEEnergyStack>,
IEnumHost {
    private static final String TAG_IO_INVENTORY = "#IO_INVENTORY";
    public List<ContainerEnergyTerminal> listeners = new ArrayList<ContainerEnergyTerminal>();
    public LiquidAIEnergy selectedEnergy;
    private IConfigManager configManager = new ConfigManager((IConfigManagerHost)this);
    private boolean updateRequsted;
    private SortOrder sortingOrder = SortOrder.NAME;
    public AIGridNodeInventory energyIOInventory = new AIGridNodeInventory("appliedintegrations.item.energy.cell.inventory", 2, 64){

        @Override
        public boolean func_94041_b(int slotID, ItemStack itemStack) {
            return Utils.getEnergyFromItemStack(itemStack, PartEnergyTerminal.this.getHostWorld()) != null;
        }
    };

    public PartEnergyTerminal() {
        super(PartEnum.EnergyTerminal);
        this.configManager.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.configManager.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.configManager.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.energyIOInventory.readFromNBT(data.func_150295_c(TAG_IO_INVENTORY, 10));
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        data.func_74782_a(TAG_IO_INVENTORY, (NBTBase)this.energyIOInventory.writeToNBT());
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d position) {
        if (this.isActive()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiTerminalPart, player, this.getHostSide(), this.getHostPos());
            this.updateRequsted = true;
            return true;
        }
        return false;
    }

    @Override
    protected AIGridNodeInventory getUpgradeInventory() {
        return null;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        helper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public int getLightLevel() {
        if (this.isActive()) {
            return 9;
        }
        return 0;
    }

    public void onEntityCollision(Entity entity) {
    }

    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.TERMINAL_HAS_CHANNEL;
            }
            return PartModelEnum.TERMINAL_ON;
        }
        return PartModelEnum.TERMINAL_OFF;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(1, 1, false, false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        IMEMonitor<IAEEnergyStack> inv;
        if (this.updateRequsted && !this.getHostWorld().field_72995_K && (inv = this.getEnergyInventory()) != null) {
            for (ContainerEnergyTerminal listener : this.listeners) {
                NetworkHandler.sendTo(new PacketTerminalUpdate((IItemList<IAEEnergyStack>)inv.getStorageList(), this.sortingOrder, this), (EntityPlayerMP)listener.player);
                this.updateRequsted = false;
            }
        }
        ItemStack inputStack = this.energyIOInventory.func_70301_a(0);
        LiquidAIEnergy energyFromItemStack = Utils.getEnergyFromItemStack(inputStack, this.getHostWorld());
        if (inputStack != null && energyFromItemStack != null) {
            int injected;
            IAEEnergyStack storedStack;
            StackCapabilityHelper helper = new StackCapabilityHelper(inputStack);
            boolean success = false;
            int stored = helper.getStored(energyFromItemStack);
            if (this.selectedEnergy != energyFromItemStack || stored > 0) {
                int extracted;
                int storedEnergy = helper.getStored(energyFromItemStack);
                if (storedEnergy > 0 && (extracted = helper.extractEnergy(energyFromItemStack, storedEnergy, Actionable.MODULATE)) > 0) {
                    this.injectEnergy(new EnergyStack(energyFromItemStack, extracted), Actionable.MODULATE);
                    success = true;
                }
            } else if (stored == 0 && (storedStack = (IAEEnergyStack)this.getEnergyInventory().getStorageList().findPrecise((IAEStack)AEEnergyStack.fromStack(new EnergyStack(energyFromItemStack, 0L)))) != null && (injected = helper.injectEnergy(storedStack.getEnergy(), (int)storedStack.getStackSize(), Actionable.MODULATE)) > 0) {
                this.extractEnergy(new EnergyStack(energyFromItemStack, injected), Actionable.MODULATE);
                success = true;
            }
            if (success) {
                this.energyIOInventory.func_70299_a(0, ItemStack.field_190927_a);
                this.energyIOInventory.func_70299_a(1, inputStack);
            }
        }
        return TickRateModulation.SAME;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node == null) {
            return null;
        }
        IGrid grid = node.getGrid();
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        return storage.getInventory(channel);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEEnergyStack> monitor, Iterable<IAEEnergyStack> change, IActionSource actionSource) {
        for (ContainerEnergyTerminal listener : this.listeners) {
            NetworkHandler.sendTo(new PacketTerminalUpdate((IItemList<IAEEnergyStack>)((IMEMonitor)monitor).getStorageList(), this.sortingOrder, this), (EntityPlayerMP)listener.player);
        }
    }

    public void onListUpdate() {
    }

    public SortOrder getSortOrder() {
        return this.sortingOrder;
    }

    @Override
    public void setEnumVal(Enum val) {
        this.sortingOrder = (SortOrder)val;
    }
}

