/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Parts.AIRotatablePart;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.TesrRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.parts.reporting.PartStorageMonitor;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartEnergyStorageMonitor
extends AIRotatablePart
implements IStackWatcherHost,
IPowerChannelState,
IPartStorageMonitor {
    private static final String KEY_IS_LOCKED = "#IS_LOCKED";
    private static final String KEY_STACK_TAG = "#STACK_TAG";
    private static final String KEY_HAS_STACK = "#HAS_STACK";
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private String lastHumanReadableText;
    private IAEEnergyStack currentStack;
    private IStackWatcher watcher;
    private boolean isLocked;

    public PartEnergyStorageMonitor() {
        super(PartEnum.EnergyStorageMonitor);
    }

    private void onStackWatchUpdate() throws GridAccessException {
        if (this.watcher == null) {
            return;
        }
        this.watcher.reset();
        if (this.currentStack == null) {
            return;
        }
        this.watcher.add((IAEStack)this.currentStack);
        this.queryStackUpdate();
    }

    private void queryStackUpdate() throws GridAccessException {
        if (this.currentStack == null) {
            return;
        }
        IAEEnergyStack output = (IAEEnergyStack)this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class)).getStorageList().findPrecise((IAEStack)this.currentStack);
        this.currentStack.setStackSize(output == null ? 0L : output.getStackSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void renderEnergy(Tessellator tess, IAEEnergyStack energyStack) {
        block5: {
            try {
                int light = 0x1000100;
                int lightU = light % 65536;
                int lightV = light / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lightU * 0.8f), (float)((float)lightV * 0.8f));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179101_C();
                Minecraft mc = Minecraft.func_71410_x();
                ResourceLocation liquidEnergyFluidStill = energyStack.getEnergy().getStill();
                if (liquidEnergyFluidStill == null) break block5;
                TextureMap textureMap = mc.func_147117_R();
                TextureAtlasSprite icon = textureMap.func_110572_b(liquidEnergyFluidStill.toString());
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                try {
                    buffer.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                finally {
                    tess.func_78381_a();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        boolean hasStack = this.currentStack != null;
        stream.writeBoolean(hasStack);
        if (hasStack) {
            this.currentStack.writeToPacket(stream);
        }
        stream.writeBoolean(this.isLocked);
    }

    @Override
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean readFromStream = super.readFromStream(stream);
        if (stream.readBoolean()) {
            this.currentStack = AEEnergyStack.fromPacket(stream);
        }
        this.isLocked = stream.readBoolean();
        return readFromStream;
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        IAEEnergyStack stack = this.getDisplayed();
        if (stack == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        EnumFacing facing = this.getHostSide().getFacing();
        TesrRenderHelper.moveToFace((EnumFacing)facing);
        TesrRenderHelper.rotateToFace((EnumFacing)facing, (byte)this.renderRotation);
        long stackSize = this.currentStack.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GlStateManager.func_179109_b((float)0.0f, (float)0.17f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        GlStateManager.func_179109_b((float)(-0.5f * (float)width), (float)0.0f, (float)0.5f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
        this.renderEnergy(Tessellator.func_178181_a(), this.currentStack);
        GlStateManager.func_179121_F();
    }

    @Override
    protected AIGridNodeInventory getUpgradeInventory() {
        return null;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    public IPartModel getStaticModels() {
        if (this.isActive()) {
            if (this.isLocked()) {
                return PartStorageMonitor.MODELS_LOCKED_HAS_CHANNEL;
            }
            return PartStorageMonitor.MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return PartStorageMonitor.MODELS_LOCKED_ON;
            }
            return PartStorageMonitor.MODELS_ON;
        }
        if (this.isLocked()) {
            return PartStorageMonitor.MODELS_LOCKED_OFF;
        }
        return PartStorageMonitor.MODELS_OFF;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound stackTag = new NBTTagCompound();
        data.func_74757_a(KEY_HAS_STACK, this.currentStack != null && this.currentStack.getEnergy() != null);
        if (this.currentStack != null && this.currentStack.getEnergy() != null) {
            this.currentStack.writeToNBT(stackTag);
        }
        data.func_74782_a(KEY_STACK_TAG, (NBTBase)stackTag);
        data.func_74757_a(KEY_IS_LOCKED, this.isLocked);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74767_n(KEY_HAS_STACK)) {
            this.currentStack = AEEnergyStack.fromNBT(data.func_74775_l(KEY_STACK_TAG));
        }
        this.isLocked = data.func_74767_n(KEY_IS_LOCKED);
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 0 : 1;
    }

    public void onEntityCollision(Entity entity) {
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    public void updateWatcher(IStackWatcher w) {
        this.watcher = w;
        try {
            this.onStackWatchUpdate();
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean onShiftActivate(EntityPlayer player, EnumHand hand, Vec3d vec3d) {
        World hostWorld = this.getHostWorld();
        if (hostWorld.field_72995_K || !player.func_184586_b(hand).func_190926_b()) {
            return true;
        }
        if (!this.getProxy().isActive() || !Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        this.isLocked = !this.isLocked;
        player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get());
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d position) {
        if (this.getHostWorld().field_72995_K) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        if (!this.isLocked) {
            ItemStack maybeEnergyStack = player.func_184586_b(enumHand);
            LiquidAIEnergy energy = Utils.getEnergyFromItemStack(maybeEnergyStack, this.getHostWorld());
            if (energy == null) {
                return false;
            }
            this.currentStack = AEEnergyStack.fromStack(new EnergyStack(energy, 1L));
            try {
                this.onStackWatchUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        } else {
            return super.onActivate(player, enumHand, position);
        }
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    public void onStackChange(IItemList list, IAEStack oldStack, IAEStack diffStack, IActionSource src, IStorageChannel chan) {
        if (this.currentStack == null) {
            return;
        }
        this.currentStack.setStackSize(oldStack == null ? 0L : oldStack.getStackSize());
        String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(this.currentStack.getStackSize());
        if (!humanReadableText.equals(this.lastHumanReadableText)) {
            this.lastHumanReadableText = humanReadableText;
            this.getHost().markForUpdate();
        }
    }

    public IAEEnergyStack getDisplayed() {
        return this.currentStack;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean showNetworkInfo(RayTraceResult where) {
        return false;
    }
}

