/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Container.part.ContainerEnergyFormation;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Helpers.Energy.StackCapabilityHelper;
import AppliedIntegrations.Inventory.Handlers.HandlerEnergyStorageBusContainer;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketFilterServerToClient;
import AppliedIntegrations.Parts.AIPlanePart;
import AppliedIntegrations.Parts.IEnergyMachine;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.Utils.ChangeHandler;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import appeng.util.item.ItemList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public class PartEnergyFormation
extends AIPlanePart
implements ICellContainer,
IEnergyMachine {
    public final List<LiquidAIEnergy> filteredEnergies = new LinkedList<LiquidAIEnergy>();
    private List<ChangeHandler<LiquidAIEnergy>> filteredEnergiesChangeHandler = new ArrayList<ChangeHandler<LiquidAIEnergy>>();
    private boolean updateRequested;
    public List<ContainerEnergyFormation> linkedListeners = new ArrayList<ContainerEnergyFormation>();

    public PartEnergyFormation() {
        super(PartEnum.EnergyFormation);
        for (int index = 0; index < 18; ++index) {
            this.filteredEnergies.add(null);
            this.filteredEnergiesChangeHandler.add(new ChangeHandler());
        }
    }

    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.FORMATION_HAS_CHANNEL;
            }
            return PartModelEnum.FORMATION_ON;
        }
        return PartModelEnum.FORMATION_OFF;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiFormationPlane, player, this.getHostSide(), this.getHostTile().func_174877_v());
            this.updateRequested = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doWork(int ticksSinceLastCall) {
        for (ContainerEnergyFormation listener : this.linkedListeners) {
            for (int i = 0; i < 18; ++i) {
                int finalI = i;
                this.filteredEnergiesChangeHandler.get(i).onChange(this.filteredEnergies.get(i), energy -> NetworkHandler.sendTo(new PacketFilterServerToClient((LiquidAIEnergy)((Object)energy), finalI, this), (EntityPlayerMP)listener.player));
                if (!this.updateRequested) continue;
                NetworkHandler.sendTo(new PacketFilterServerToClient(this.filteredEnergies.get(i), finalI, this), (EntityPlayerMP)listener.player);
            }
        }
        this.updateRequested = false;
    }

    public void blinkCell(int slot) {
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (channel != this.getChannel() || this.currentEntities.isEmpty()) {
            return new LinkedList<IMEInventoryHandler>();
        }
        return Collections.singletonList(new IMEInventoryHandler<IAEEnergyStack>(){

            public AccessRestriction getAccess() {
                return AccessRestriction.WRITE;
            }

            public boolean isPrioritized(IAEEnergyStack input) {
                return false;
            }

            public boolean canAccept(IAEEnergyStack input) {
                return input instanceof IAEEnergyStack;
            }

            public int getPriority() {
                return 0;
            }

            public int getSlot() {
                return 0;
            }

            public boolean validForPass(int i) {
                return true;
            }

            public IAEEnergyStack injectItems(IAEEnergyStack input, Actionable type, IActionSource src) {
                if (input == null) {
                    return null;
                }
                if (!HandlerEnergyStorageBusContainer.listContainsNonNullValues(PartEnergyFormation.this.filteredEnergies) && !PartEnergyFormation.this.filteredEnergies.contains((Object)input.getEnergy())) {
                    return input;
                }
                if (PartEnergyFormation.this.currentEntities.isEmpty()) {
                    return input;
                }
                if (input.getStackSize() > Integer.MAX_VALUE) {
                    return input;
                }
                int amountInjected = 0;
                int request = (int)input.getStackSize();
                for (Entity workingEntity : PartEnergyFormation.this.currentEntities) {
                    if (workingEntity instanceof EntityItem) {
                        amountInjected += PartEnergyFormation.this.fillStack(((EntityItem)workingEntity).func_92059_d(), workingEntity, request);
                        continue;
                    }
                    if (!(workingEntity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)workingEntity;
                    for (ItemStack stack : player.field_71071_by.field_70462_a) {
                        amountInjected += PartEnergyFormation.this.fillStack(stack, workingEntity, request);
                    }
                }
                if ((long)amountInjected == input.getStackSize()) {
                    return null;
                }
                return (IAEEnergyStack)((IAEEnergyStack)input.copy()).setStackSize(input.getStackSize() - (long)amountInjected);
            }

            public IAEEnergyStack extractItems(IAEEnergyStack request, Actionable mode, IActionSource src) {
                return null;
            }

            public IItemList getAvailableItems(IItemList out) {
                return new ItemList();
            }

            public IStorageChannel getChannel() {
                return AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
            }
        });
    }

    private int fillStack(ItemStack stack, Entity ent, int request) {
        StackCapabilityHelper helper = new StackCapabilityHelper(stack);
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            if (!helper.hasCapability(energy)) continue;
            int injected = helper.injectEnergy(energy, request, Actionable.MODULATE);
            if (injected > 0) {
                this.spawnLightning(ent);
            }
            return injected;
        }
        return 0;
    }

    public int getPriority() {
        return 0;
    }

    public void saveChanges(@Nullable ICellInventory<?> iCellInventory) {
        if (iCellInventory != null) {
            iCellInventory.persist();
        }
        this.getHostTile().func_145831_w().func_175646_b(this.getHostTile().func_174877_v(), this.getHostTile());
    }

    @Override
    public void updateFilter(LiquidAIEnergy energy, int index) {
        this.filteredEnergies.set(index, energy);
    }
}

