/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Helpers.Energy.CapabilityHelper;
import AppliedIntegrations.Parts.AIOPart;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;

public class PartEnergyExport
extends AIOPart {
    public PartEnergyExport() {
        super(PartEnum.EnergyExportBus);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public TickRateModulation doWork(int valuedTransfer, IGridNode node) {
        CapabilityHelper helper = new CapabilityHelper(this.adjacentEnergyStorage, this.getHostSide().getOpposite());
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            if (!this.filteredEnergies.contains((Object)energy) || !helper.operatesEnergy(energy)) continue;
            int extracted = this.extractEnergy(new EnergyStack(energy, valuedTransfer), Actionable.SIMULATE);
            int received = helper.receiveEnergy(extracted, true, energy);
            this.extractEnergy(new EnergyStack(energy, helper.receiveEnergy(received, false, energy)), Actionable.MODULATE);
            if (extracted <= 0) continue;
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 0.0f;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.EXPORT_HAS_CHANNEL;
            }
            return PartModelEnum.EXPORT_ON;
        }
        return PartModelEnum.EXPORT_OFF;
    }
}

