/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Botania;

import AppliedIntegrations.Helpers.ManaInterfaceDuality;
import AppliedIntegrations.Parts.Energy.PartEnergyInterface;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.api.Botania.IManaInterface;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import AppliedIntegrations.api.IEnergyInterfaceDuality;
import AppliedIntegrations.grid.Mana.AEManaStack;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.botania.api.mana.spark.ISparkAttachable", modid="botania", striprefs=true), @Optional.Interface(iface="vazkii.botania.api.mana.spark.ISparkEntity", modid="botania", striprefs=true), @Optional.Interface(iface="vazkii.botania.api.mana.IManaReceiver", modid="botania", striprefs=true)})
public class PartManaInterface
extends PartEnergyInterface
implements IManaReceiver,
ISparkAttachable,
IManaInterface {
    private static final String TAG_MANA = "#mana";
    private final int capacity = 100000;
    private int currentMana = 0;
    private boolean isManaFiltered = false;

    public PartManaInterface() {
        super(PartEnum.ManaInterface);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a(TAG_MANA, this.currentMana);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.currentMana = tag.func_74762_e(TAG_MANA);
    }

    public boolean isFull() {
        return this.currentMana == 100000;
    }

    public void recieveMana(int mana) {
        this.currentMana += mana;
        if (this.currentMana > 100000) {
            this.currentMana = 100000;
        }
        if (this.currentMana < 0) {
            this.currentMana = 0;
        }
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        return true;
    }

    @Override
    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.STORAGE_INTERFACE_MANA_HAS_CHANNEL;
            }
            return PartModelEnum.STORAGE_INTERFACE_MANA_ON;
        }
        return PartModelEnum.STORAGE_INTERFACE_MANA_OFF;
    }

    @Override
    @Nonnull
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (Platform.isServer()) {
            try {
                if (this.isManaFiltered) {
                    this.doExtractDualityWork(Actionable.MODULATE);
                } else {
                    this.doInjectDualityWork(Actionable.MODULATE);
                }
            }
            catch (NullNodeConnectionException | GridAccessException throwable) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public IEnergyInterfaceDuality getDuality() {
        return new ManaInterfaceDuality(this);
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return true;
    }

    public void attachSpark(ISparkEntity iSparkEntity) {
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, 100000 - this.getCurrentMana());
    }

    public int getCurrentMana() {
        return this.currentMana;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.getHostTile().func_145831_w().func_175647_a(Entity.class, new AxisAlignedBB(this.getHostTile().func_174877_v().func_177984_a(), this.getHostTile().func_174877_v().func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int extractMana(int resource, Actionable actionable) throws GridAccessException {
        if (this.getProxy().getNode() == null) {
            return 0;
        }
        IStorageGrid storage = this.getProxy().getStorage();
        IAEManaStack notRemoved = (IAEManaStack)storage.getInventory((IStorageChannel)this.getManaChannel()).extractItems((IAEStack)new AEManaStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource;
        }
        return (int)((long)resource - notRemoved.getStackSize());
    }

    @Override
    public int injectMana(int resource, Actionable actionable) throws GridAccessException {
        if (this.getProxy().getNode() == null) {
            return 0;
        }
        IStorageGrid storage = this.getProxy().getStorage();
        IAEManaStack returnAmount = (IAEManaStack)storage.getInventory((IStorageChannel)this.getManaChannel()).injectItems((IAEStack)new AEManaStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (returnAmount == null) {
            return resource;
        }
        return (int)((long)resource - returnAmount.getStackSize());
    }

    @Override
    public int getManaStored() {
        return this.currentMana;
    }

    @Override
    public void modifyManaStorage(int mana) {
        this.currentMana += mana;
        if (this.currentMana > 100000) {
            this.currentMana = 100000;
        } else if (this.currentMana < 0) {
            this.currentMana = 0;
        }
    }

    private IManaStorageChannel getManaChannel() {
        return (IManaStorageChannel)AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class);
    }
}

