/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts;

import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.grid.AEEnergyStack;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AIPart
implements IPart,
IGridHost,
IActionHost,
IPowerChannelState,
ISyncHost,
IGridProxyable {
    protected static final int ACTIVE_TERMINAL_LIGHT_LEVEL = 9;
    private static final String NBT_KEY_OWNER = "Owner";
    private final ItemStack associatedItem;
    protected IPartHost host;
    protected TileEntity hostTile;
    private AEPartLocation cableSide;
    private AENetworkProxy proxy;
    private boolean isActive;
    private boolean isPowered;
    private int ownerID;

    public AIPart(PartEnum associatedPart) {
        this.associatedItem = associatedPart.getStack();
        this.proxy = new AENetworkProxy((IGridProxyable)this, "AIPart Proxy", this.associatedItem, true);
        this.proxy.setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public int getX() {
        if (this.getHost() != null) {
            return this.getHost().getLocation().x;
        }
        return 0;
    }

    public final IPartHost getHost() {
        return this.host;
    }

    public int getY() {
        if (this.getHost() != null) {
            return this.getHost().getLocation().y;
        }
        return 0;
    }

    public int getZ() {
        if (this.getHost() != null) {
            return this.getHost().getLocation().z;
        }
        return 0;
    }

    protected abstract AIGridNodeInventory getUpgradeInventory();

    protected TileEntity getFacingTile() {
        if (this.hostTile == null) {
            return null;
        }
        World world = this.hostTile.func_145831_w();
        int x = this.hostTile.func_174877_v().func_177958_n();
        int y = this.hostTile.func_174877_v().func_177956_o();
        int z = this.hostTile.func_174877_v().func_177952_p();
        return world.func_175625_s(new BlockPos(x + this.cableSide.xOffset, y + this.cableSide.yOffset, z + this.cableSide.zOffset));
    }

    protected boolean canDoWork(RedstoneMode mode) {
        boolean canWork = true;
        if (mode == RedstoneMode.HIGH_SIGNAL) {
            canWork = this.isReceivingRedstonePower();
        }
        if (mode == RedstoneMode.LOW_SIGNAL) {
            boolean bl = canWork = !this.isReceivingRedstonePower();
        }
        if (mode == RedstoneMode.SIGNAL_PULSE) {
            canWork = false;
        }
        return canWork;
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    public IGridNode getGridNode(AEPartLocation direction) {
        return this.getGridNode();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItemStack(PartItemStack.BREAK));
        this.getDrops(drops, false);
        this.host.removePart(this.cableSide, false);
    }

    public ItemStack getItemStack(PartItemStack type) {
        ItemStack itemStack = this.associatedItem.func_77946_l();
        if (type == PartItemStack.WRENCH) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.writeToNBT(itemNBT, PartItemStack.WRENCH);
            if (!itemNBT.func_82582_d()) {
                itemStack.func_77982_d(itemNBT);
            }
        }
        return itemStack;
    }

    public boolean requireDynamicRender() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, PartItemStack.WORLD);
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b(NBT_KEY_OWNER)) {
            this.ownerID = data.func_74762_e(NBT_KEY_OWNER);
        }
    }

    public abstract int getLightLevel();

    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos blockPos1) {
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    public void writeToStream(ByteBuf stream) throws IOException {
        stream.writeBoolean(this.isActive());
        stream.writeBoolean(this.isPowered());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean oldActive = this.isActive;
        boolean oldPowered = this.isPowered;
        this.isActive = stream.readBoolean();
        this.isPowered = stream.readBoolean();
        return oldActive != this.isActive || oldPowered != this.isPowered;
    }

    public IGridNode getGridNode() {
        return this.getProxy().getNode();
    }

    public void removeFromWorld() {
        if (this.getProxy().getNode() != null) {
            this.getProxy().getNode().destroy();
        }
    }

    public void addToWorld() {
        if (this.getHostWorld().field_72995_K) {
            return;
        }
        this.getProxy().onReady();
        this.getProxy().getNode().setPlayerID(this.ownerID);
        if (this.hostTile != null && this.host != null) {
            this.getProxy().getNode().updateState();
        }
        this.updateStatus();
    }

    private void updateStatus() {
        boolean currentlyActive;
        if (this.getHostWorld().field_72995_K) {
            return;
        }
        if (this.getProxy().getNode() != null && (currentlyActive = this.getProxy().isActive()) != this.isActive) {
            this.isActive = currentlyActive;
            this.host.markForUpdate();
        }
        this.onNeighborChanged(null, null, null);
    }

    public final TileEntity getHostTile() {
        return this.hostTile;
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public final void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        this.cableSide = side;
        this.host = host;
        this.hostTile = tile;
    }

    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        return !player.func_70093_af();
    }

    public boolean onShiftActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    public void randomDisplayTick(World world, BlockPos blockPos, Random random) {
    }

    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack stack, AEPartLocation side) {
        this.ownerID = AEApi.instance().registries().players().getID(player.func_146103_bH());
    }

    public boolean canBePlacedOn(BusSupport type) {
        return type == BusSupport.CABLE;
    }

    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        if (saveType == PartItemStack.WORLD) {
            data.func_74768_a(NBT_KEY_OWNER, this.ownerID);
        }
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public final DimensionalCoord getLocation() {
        return new DimensionalCoord(this.hostTile.func_145831_w(), this.hostTile.func_174877_v().func_177958_n(), this.hostTile.func_174877_v().func_177956_o(), this.hostTile.func_174877_v().func_177952_p());
    }

    public void gridChanged() {
    }

    public boolean isPowered() {
        try {
            if (Platform.isServer() && this.proxy != null) {
                IEnergyGrid eGrid = this.proxy.getEnergy();
                this.isPowered = eGrid != null ? eGrid.isNetworkPowered() : false;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.isPowered;
    }

    public boolean isActive() {
        if (Platform.isServer()) {
            this.isActive = this.getProxy().getNode() != null ? this.getProxy().isActive() : false;
        }
        return this.isActive;
    }

    public boolean isReceivingRedstonePower() {
        if (this.host != null) {
            return this.host.hasRedstone(this.cableSide);
        }
        return false;
    }

    public final void markForSave() {
        if (this.host != null) {
            this.host.markForSave();
        }
    }

    public final void markForUpdate() {
        if (this.host != null) {
            this.host.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void setPower(MENetworkPowerStatusChange event) {
        this.updateStatus();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged event) {
        this.updateStatus();
    }

    @Override
    public BlockPos getHostPos() {
        return this.getHostTile().func_174877_v();
    }

    @Override
    public World getHostWorld() {
        return this.getHostTile().func_145831_w();
    }

    @Override
    public AEPartLocation getHostSide() {
        return this.cableSide;
    }

    public IMEMonitor<IAEEnergyStack> getEnergyInventory() {
        IGridNode n = this.getGridNode();
        if (n == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)n.getGrid().getCache(IStorageGrid.class);
        return storage.getInventory((IStorageChannel)this.getChannel());
    }

    public IEnergyStorageChannel getChannel() {
        return (IEnergyStorageChannel)AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
    }

    public int extractEnergy(EnergyStack resource, Actionable actionable) {
        IAEEnergyStack extracted = (IAEEnergyStack)this.getEnergyInventory().extractItems((IAEStack)AEEnergyStack.fromStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (extracted == null) {
            return 0;
        }
        return (int)extracted.getStackSize();
    }

    public int injectEnergy(EnergyStack resource, Actionable actionable) {
        IAEEnergyStack notInjected = (IAEEnergyStack)this.getEnergyInventory().injectItems((IAEStack)AEEnergyStack.fromStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (notInjected == null) {
            return (int)resource.amount;
        }
        return (int)(resource.amount - notInjected.getStackSize());
    }
}

