/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts;

import AppliedIntegrations.Container.part.ContainerPartEnergyIOBus;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Inventory.Manager.UpgradeInventoryManager;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketFilterServerToClient;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.Parts.IEnergyMachine;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Utils.ChangeHandler;
import AppliedIntegrations.api.IEnumHost;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.EnumCapabilityType;
import appeng.api.config.RedstoneMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public abstract class AIOPart
extends AIPart
implements IGridTickable,
IEnergyMachine,
IPriorityHostExtended,
IEnumHost {
    public static final int MAX_FILTER_SIZE = 9;
    public List<LiquidAIEnergy> filteredEnergies = new ArrayList<LiquidAIEnergy>(9);
    private static final int MINIMUM_TICKS_PER_OPERATION = 2;
    private static final int MAXIMUM_TICKS_PER_OPERATION = 40;
    private static final int BASE_ENERGY_TRANSFER = 4000;
    private static final int MAXIMUM_TRANSFER_PER_SECOND = 36000;
    private static final int MINIMUM_TRANSFER_PER_SECOND = 4000;
    private static final int TRANSFER_PER_UPGRADE = 8090;
    private static final String NBT_KEY_REDSTONE_MODE = "redstoneMode";
    private static final String NBT_KEY_FILTER_NUMBER = "EnergyFilter#";
    protected int maxTransfer;
    protected TileEntity adjacentEnergyStorage;
    private EntityPlayer player;
    private boolean lastRedstone;
    private List<ContainerPartEnergyIOBus> listeners = new ArrayList<ContainerPartEnergyIOBus>();
    private byte upgradeSpeedCount = 0;
    private List<ChangeHandler<LiquidAIEnergy>> filteredEnergiesChangeHandler = new ArrayList<ChangeHandler<LiquidAIEnergy>>();
    public UpgradeInventoryManager upgradeInventoryManager = new UpgradeInventoryManager(this, "ME Energy Export/Import Bus", 4, stack -> AIGridNodeInventory.validateStack(stack));
    private int priority = 0;

    public AIOPart(PartEnum associatedPart) {
        super(associatedPart);
        this.maxTransfer = 50000 * this.upgradeSpeedCount;
        for (int i = 0; i < 9; ++i) {
            this.filteredEnergies.add(i, null);
            this.filteredEnergiesChangeHandler.add(new ChangeHandler());
        }
    }

    public void addListener(ContainerPartEnergyIOBus container) {
        if (!this.listeners.contains(container)) {
            this.listeners.add(container);
        }
    }

    @Override
    public AIGridNodeInventory getUpgradeInventory() {
        return this.upgradeInventoryManager.upgradeInventory;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        for (int index = 0; index < 9; ++index) {
            if (!data.func_74764_b(NBT_KEY_FILTER_NUMBER + index)) continue;
            this.filteredEnergies.set(index, LiquidAIEnergy.energies.get(data.func_74779_i(NBT_KEY_FILTER_NUMBER + index)));
        }
        this.upgradeInventoryManager.upgradeInventory.readFromNBT(data.func_150295_c("upgradeInventoryManager", 10));
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 4 : 0;
    }

    @Override
    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos blockPos1) {
        if (this.getHostWorld().field_72995_K) {
            return;
        }
        this.adjacentEnergyStorage = null;
        TileEntity tileEntity = this.getFacingTile();
        if (tileEntity == null) {
            return;
        }
        for (EnumCapabilityType type : EnumCapabilityType.values) {
            if (!type.isUsesType(tileEntity, this.getHostSide().getFacing().func_176734_d())) continue;
            this.adjacentEnergyStorage = tileEntity;
            break;
        }
        if (this.upgradeInventoryManager.redstoneMode == RedstoneMode.SIGNAL_PULSE && this.isReceivingRedstonePower() != this.lastRedstone) {
            this.lastRedstone = this.isReceivingRedstonePower();
            this.processTick(20);
        }
    }

    public void onEntityCollision(Entity entity) {
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d position) {
        super.onActivate(player, hand, position);
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiIOPart, player, this.getHostSide(), this.getHostTile().func_174877_v());
            this.player = player;
            return true;
        }
        return false;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventoryManager.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 0.0f;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType == PartItemStack.WORLD || saveType == PartItemStack.WRENCH) {
            int i = 0;
            for (LiquidAIEnergy energy : this.filteredEnergies) {
                if (energy != null) {
                    data.func_74778_a(NBT_KEY_FILTER_NUMBER + i, energy.getTag());
                }
                ++i;
            }
            if (saveType == PartItemStack.WORLD) {
                if (this.upgradeInventoryManager.redstoneMode != RedstoneMode.IGNORE) {
                    data.func_74768_a(NBT_KEY_REDSTONE_MODE, this.upgradeInventoryManager.redstoneMode.ordinal());
                }
                data.func_74782_a("upgradeInventoryManager", (NBTBase)this.upgradeInventoryManager.upgradeInventory.writeToNBT());
            }
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(2, 40, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.updateGui();
        if (this.canDoWork(this.upgradeInventoryManager.redstoneMode)) {
            return this.processTick(ticksSinceLastCall);
        }
        return TickRateModulation.IDLE;
    }

    private TickRateModulation processTick(int ticksSinceLastCall) {
        int transferAmountPerSecond = this.getTransferAmountPerSecond();
        int transferAmount = (int)((float)transferAmountPerSecond * ((float)ticksSinceLastCall / 20.0f));
        transferAmount = Math.min(transferAmount, 36000);
        transferAmount = Math.max(transferAmount, 4000);
        return this.doWork(transferAmount, this.getProxy().getNode());
    }

    private void updateGui() {
        for (int i = 0; i < 9; ++i) {
            int finalI = i;
            this.filteredEnergiesChangeHandler.get(i).onChange(this.filteredEnergies.get(i), energy -> this.notifyListenersOfFilterEnergyChange(finalI, (LiquidAIEnergy)((Object)energy)));
            this.notifyListenersOfFilterEnergyChange(i, this.filteredEnergies.get(i));
        }
    }

    protected int getTransferAmountPerSecond() {
        return 4000 + this.upgradeSpeedCount * 8090;
    }

    public abstract TickRateModulation doWork(int var1, IGridNode var2);

    private void notifyListenersOfFilterEnergyChange(int i, LiquidAIEnergy energy) {
        if (this.player != null) {
            NetworkHandler.sendTo(new PacketFilterServerToClient(energy, i, this), (EntityPlayerMP)this.player);
        }
    }

    public void removeListener(ContainerPartEnergyIOBus container) {
        this.listeners.remove(container);
    }

    @Override
    public final void updateFilter(LiquidAIEnergy energy, int index) {
        this.filteredEnergies.set(index, energy);
        this.notifyListenersOfFilterEnergyChange(index, energy);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    public ItemStack getItemStackRepresentation() {
        return this.getItemStack(PartItemStack.BREAK);
    }

    public GuiBridge getGuiBridge() {
        return null;
    }

    @Override
    @Nonnull
    public AIGuiHandler.GuiEnum getGui() {
        return AIGuiHandler.GuiEnum.GuiIOPart;
    }

    @Override
    public void setEnumVal(Enum val) {
        this.upgradeInventoryManager.acceptVal(val);
        this.upgradeInventoryManager.redstoneControlled = val != RedstoneMode.IGNORE;
    }
}

