/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Network.Packets.PartGUI;

import AppliedIntegrations.Network.ClientPacketHelper;
import AppliedIntegrations.Network.Packets.AIPacket;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnergyList;
import appeng.api.config.SortOrder;
import appeng.api.storage.data.IItemList;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class PacketTerminalUpdate
extends AIPacket {
    public AIPart part;
    public IItemList<IAEEnergyStack> list;
    public SortOrder order;

    public PacketTerminalUpdate() {
    }

    public PacketTerminalUpdate(IItemList<IAEEnergyStack> monitor, @Nonnull SortOrder order, AIPart partToken) {
        this.list = monitor;
        this.part = partToken;
        this.order = order;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        EnergyList list = new EnergyList();
        for (int i = 0; i < size; ++i) {
            LiquidAIEnergy energy = this.readEnergy(buf);
            if (energy == null) continue;
            AEEnergyStack stack = AEEnergyStack.fromStack(new EnergyStack(energy, 0L));
            stack.setStackSize(buf.readLong());
            list.add(stack);
        }
        this.part = (AIPart)ClientPacketHelper.readSyncHostClient(buf);
        this.list = list;
        this.order = SortOrder.values()[buf.readByte()];
    }

    public void toBytes(ByteBuf buf) {
        int listSizeIndex = buf.writerIndex();
        buf.writeInt(this.list.size());
        int actualSize = 0;
        Iterator iterator = this.list.iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!iterator.hasNext()) continue;
            IAEEnergyStack entry = (IAEEnergyStack)iterator.next();
            this.writeEnergy(entry.getEnergy(), buf);
            buf.writeLong(entry.getStack().amount);
            ++actualSize;
        }
        buf.setInt(listSizeIndex, actualSize);
        this.writeSyncHost(this.part, buf, false);
        buf.writeByte((int)((byte)this.order.ordinal()));
    }
}

