/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Network.Packets;

import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.util.AEPartLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AIPacket
implements IMessage {
    protected LiquidAIEnergy readEnergy(ByteBuf buf) {
        int buffed = buf.readInt();
        if (buffed != -1) {
            return LiquidAIEnergy.linkedIndexMap.get(buffed);
        }
        return null;
    }

    protected void writeEnergy(LiquidAIEnergy energy, ByteBuf buf) {
        if (energy != null) {
            buf.writeInt(energy.getIndex());
        } else {
            buf.writeInt(-1);
        }
    }

    protected void writePos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    protected void writeVec(Vec3d vec, ByteBuf buf) {
        buf.writeDouble(vec.field_72450_a);
        buf.writeDouble(vec.field_72448_b);
        buf.writeDouble(vec.field_72449_c);
    }

    protected BlockPos readPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    protected Vec3d readVec(ByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    private void writeWorld(ByteBuf buf, World world) {
        buf.writeInt(world.field_73011_w.getDimension());
    }

    protected void writeEnum(Enum anum, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)anum.getDeclaringClass().getName());
        buf.writeInt(anum.ordinal());
    }

    protected void writeSyncHost(ISyncHost host, ByteBuf buf, boolean useWorld) {
        buf.writeLong(host.getHostPos().func_177986_g());
        buf.writeInt(host.getHostSide().ordinal());
        if (useWorld) {
            this.writeWorld(buf, host.getHostWorld());
        }
    }

    protected ISyncHost readSyncHost(ByteBuf buf) {
        BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
        AEPartLocation side = AEPartLocation.values()[buf.readInt()];
        World w = this.readWorld(buf);
        ISyncHost host = side == AEPartLocation.INTERNAL ? (ISyncHost)w.func_175625_s(pos) : Utils.getSyncHostByParams(pos, side, w);
        return host;
    }

    protected Enum readEnum(ByteBuf buf) {
        try {
            Class<?> enumClass = Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf));
            return (Enum)enumClass.getEnumConstants()[buf.readInt()];
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private World readWorld(ByteBuf buf) {
        return DimensionManager.getWorld((int)buf.readInt());
    }
}

