/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items.StorageCells;

import AppliedIntegrations.Integration.Botania.IBotaniaIntegrated;
import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;

public class ManaStorageCell
extends AIItemRegistrable
implements IStorageCell<IAEManaStack>,
IBotaniaIntegrated {
    private int maxBytes;

    public ManaStorageCell(String registry, int maxBytes) {
        super(registry);
        this.maxBytes = maxBytes;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        ICellInventoryHandler inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
        if (inventoryHandler != null) {
            ICellInventory cellInventory = inventoryHandler.getCellInv();
            if (cellInventory != null) {
                lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            }
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                IItemList cellEnergies = inventoryHandler.getAvailableItems(this.getChannel().createList());
                for (IAEManaStack currentStack : cellEnergies) {
                    if (currentStack == null) continue;
                    String energyInfo = TextFormatting.AQUA.toString() + "Mana x " + currentStack.getStackSize();
                    lines.add(energyInfo);
                }
            } else {
                lines.add(TextFormatting.WHITE.toString() + "Hold" + TextFormatting.DARK_AQUA.toString() + " Shift " + TextFormatting.WHITE.toString() + "for");
            }
        }
    }

    public int getBytes(@Nonnull ItemStack itemStack) {
        return this.maxBytes;
    }

    public int getBytesPerType(@Nonnull ItemStack itemStack) {
        return 1;
    }

    public int getTotalTypes(@Nonnull ItemStack itemStack) {
        return 1;
    }

    public boolean isBlackListed(@Nonnull ItemStack itemStack, @Nonnull IAEManaStack iaeManaStack) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack itemStack) {
        return true;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    @Nonnull
    public IStorageChannel<IAEManaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class);
    }

    public boolean isEditable(ItemStack itemStack) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack itemStack) {
        return new CellUpgrades(itemStack, 2);
    }

    public IItemHandler getConfigInventory(ItemStack itemStack) {
        return new CellConfig(itemStack);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }
}

