/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Container.tile.MultiController.ContainerMultiControllerTerminal;
import AppliedIntegrations.Gui.MultiController.SubGui.Buttons.GuiSecurityPermissionsButton;
import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.Storage.IChannelWidget;
import AppliedIntegrations.tile.MultiController.TileMultiControllerPort;
import appeng.api.config.IncludeExclude;
import appeng.api.config.SecurityPermissions;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkCard
extends AIItemRegistrable {
    public static final String NBT_KEY_HAS_NET = "#HAS_NETWORK";
    public static final String KEY_SUB = "#SUB_TAG";
    public static final String NBT_KEY_PORT_SIDE = "#NET_SIDE";
    public static final String NBT_KEY_PORT_ID = "#PORT_ID";
    private static final String NBT_KEY_PERMISSIONS = "#PERMISSIONS";
    private static final String NBT_KEY_LIST_SIZE = "#LIST_SIZE";
    private static final String NBT_KEY_LIST_MODE = "#LIST_MODE";

    public NetworkCard(String registry) {
        super(registry);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("appliedintegrations", "bit"), (stack, worldIn, entityIn) -> {
            NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
            if (!tag.func_74767_n(NBT_KEY_HAS_NET)) {
                tag.func_74768_a(NBT_KEY_PORT_SIDE, AEPartLocation.INTERNAL.ordinal());
            }
            return ((float)tag.func_74762_e(NBT_KEY_PORT_SIDE) + 1.0f) / 10.0f;
        });
    }

    public static Pair<LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>>, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>>> decodeDataFromTag(NBTTagCompound tag) {
        LinkedHashMap channelStackMap = new LinkedHashMap();
        LinkedHashMap channelTypeMap = new LinkedHashMap();
        GuiSecurityPermissionsButton.getPermissionList().forEach(securityPermissions -> {
            LinkedHashMap tempMap = new LinkedHashMap();
            ContainerMultiControllerTerminal.channelList.forEach((Consumer<IStorageChannel<IAEStack<?>>>)((Consumer<IStorageChannel>)chan -> tempMap.put(chan, AIConfig.defaultListMode)));
            channelTypeMap.put((SecurityPermissions)securityPermissions, tempMap);
        });
        for (int i = 0; i < GuiSecurityPermissionsButton.getPermissionList().size(); ++i) {
            NBTTagCompound securityTag = (NBTTagCompound)tag.func_74781_a("#SUB_TAG_" + GuiSecurityPermissionsButton.getPermissionList().get(i).name());
            LinkedHashMap stackMap = new LinkedHashMap();
            LinkedHashMap typeMap = new LinkedHashMap();
            for (int j = 0; j < ContainerMultiControllerTerminal.channelList.size(); ++j) {
                NBTTagCompound channelTag;
                ArrayList list = new ArrayList();
                if (securityTag == null || (channelTag = (NBTTagCompound)securityTag.func_74781_a(KEY_SUB + j)) == null) break;
                for (int k = 0; k < channelTag.func_74762_e(NBT_KEY_LIST_SIZE); ++k) {
                    NBTTagCompound stackTag = (NBTTagCompound)channelTag.func_74781_a(KEY_SUB + k);
                    AIApi.IStackDecoder decoder = Objects.requireNonNull(AIApi.instance()).getStackDecoder(ContainerMultiControllerTerminal.channelList.get(j));
                    try {
                        IAEStack<?> stack = decoder.decode(stackTag);
                        list.add(stack);
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unexpected error");
                    }
                }
                IncludeExclude mode = IncludeExclude.values()[channelTag.func_74762_e(NBT_KEY_LIST_MODE)];
                typeMap.put(ContainerMultiControllerTerminal.channelList.get(j), mode);
                stackMap.put(ContainerMultiControllerTerminal.channelList.get(j), list);
            }
            channelStackMap.put(GuiSecurityPermissionsButton.getPermissionList().get(i), stackMap);
            channelTypeMap.put(GuiSecurityPermissionsButton.getPermissionList().get(i), typeMap);
        }
        return Pair.of(channelStackMap, channelTypeMap);
    }

    public static NBTTagCompound encodeDataInTag(LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IChannelWidget<?>>>> permissionChannelWidgetMap, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>> permissionChannelModeMap, ItemStack stack) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        List<SecurityPermissions> permissionList = GuiSecurityPermissionsButton.getPermissionList();
        permissionList.forEach(securityPermissions -> {
            NBTTagCompound securityNBT = new NBTTagCompound();
            for (int j = 0; j < ContainerMultiControllerTerminal.channelList.size(); ++j) {
                IStorageChannel<? extends IAEStack<?>> chan = ContainerMultiControllerTerminal.channelList.get(j);
                NBTTagCompound channelNBT = new NBTTagCompound();
                channelNBT.func_74768_a(NBT_KEY_LIST_MODE, ((IncludeExclude)((LinkedHashMap)permissionChannelModeMap.get(securityPermissions)).get(chan)).ordinal());
                List list = (List)((LinkedHashMap)permissionChannelWidgetMap.get(securityPermissions)).get(chan);
                channelNBT.func_74768_a(NBT_KEY_LIST_SIZE, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    IChannelWidget widget = (IChannelWidget)list.get(i);
                    NBTTagCompound stackNBT = new NBTTagCompound();
                    try {
                        if (widget.getAEStack() != null) {
                            Objects.requireNonNull(AIApi.instance()).getStackEncoder(chan).encode(stackNBT, widget.getAEStack());
                        } else {
                            stackNBT.func_74772_a("Cnt", -1L);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unexpected error");
                    }
                    channelNBT.func_74782_a(KEY_SUB + i, (NBTBase)stackNBT);
                }
                securityNBT.func_74782_a(KEY_SUB + j, (NBTBase)channelNBT);
            }
            tag.func_74782_a("#SUB_TAG_" + securityPermissions.name(), (NBTBase)securityNBT);
        });
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        if (tag == null) {
            return;
        }
        AEPartLocation side = AEPartLocation.values()[tag.func_74762_e(NBT_KEY_PORT_SIDE)];
        if (side == AEPartLocation.INTERNAL) {
            return;
        }
        String str = side.name().toLowerCase();
        String name = str.substring(0, 1).toUpperCase() + str.substring(1);
        int id = tag.func_74762_e(NBT_KEY_PORT_ID);
        lines.add(I18n.func_135052_a((String)"network_card_port_side.name", (Object[])new Object[0]) + " - " + name);
        lines.add(I18n.func_135052_a((String)"network_card_port_id.name", (Object[])new Object[0]) + " - " + id);
        lines.add(tag.func_74779_i(NBT_KEY_PERMISSIONS));
        String tables = "";
        for (int i = 0; i < GuiSecurityPermissionsButton.getPermissionList().size(); ++i) {
            NBTTagCompound securityTag = (NBTTagCompound)tag.func_74781_a(KEY_SUB + GuiSecurityPermissionsButton.getPermissionList().get(i));
            for (int j = 0; j < ContainerMultiControllerTerminal.channelList.size(); ++j) {
                if (securityTag == null || securityTag.func_74781_a(KEY_SUB + j) == null) {
                    return;
                }
                NBTTagCompound channelTag = (NBTTagCompound)securityTag.func_74781_a(KEY_SUB + j);
                for (int k = 0; k < tag.func_74762_e(NBT_KEY_LIST_SIZE); ++k) {
                    NBTTagCompound stackTag = (NBTTagCompound)channelTag.func_74781_a(KEY_SUB + k);
                    if (stackTag.func_74763_f("Cnt") != -1L) continue;
                    tables = !tables.equals("") ? tables.concat(" " + I18n.func_135052_a((String)GuiSecurityPermissionsButton.getPermissionList().get(i).getUnlocalizedName(), (Object[])new Object[0])) : I18n.func_135052_a((String)GuiSecurityPermissionsButton.getPermissionList().get(i).getUnlocalizedName(), (Object[])new Object[0]);
                }
            }
        }
        lines.add("Tables: " + tables);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)player.func_184586_b(hand));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMultiControllerPort) {
            TileMultiControllerPort port = (TileMultiControllerPort)tile;
            tag.func_74757_a(NBT_KEY_HAS_NET, port.getSideVector() != AEPartLocation.INTERNAL);
            tag.func_74768_a(NBT_KEY_PORT_SIDE, port.getSideVector().ordinal());
            tag.func_74768_a(NBT_KEY_PORT_ID, port.getPortID());
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            player.func_184586_b(hand).func_77982_d(new NBTTagCompound());
        }
        return EnumActionResult.FAIL;
    }
}

