/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.AppliedIntegrations;
import AppliedIntegrations.Integration.BloodMagic.BloodMagicLoader;
import AppliedIntegrations.Integration.Botania.BotaniaLoader;
import AppliedIntegrations.Integration.Embers.EmberLoader;
import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.Items.AdvancedNetworkTool.AdvancedNetworkTool;
import AppliedIntegrations.Items.Botania.Encorium.MaterialEncorium;
import AppliedIntegrations.Items.Botania.Encorium.MaterialEncoriumDust;
import AppliedIntegrations.Items.Botania.Encorium.MaterialEncoriumSeed;
import AppliedIntegrations.Items.Botania.MEManaMirror;
import AppliedIntegrations.Items.Botania.ManaAnnihilationCore;
import AppliedIntegrations.Items.Botania.ManaFormationCore;
import AppliedIntegrations.Items.GraphTool;
import AppliedIntegrations.Items.ItemEnergyWirelessTerminal;
import AppliedIntegrations.Items.NetworkCard;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyAnnihilation;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyExport;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyFormation;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyImport;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyInterface;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyStorage;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyStorageMonitor;
import AppliedIntegrations.Items.Part.Energy.ItemPartEnergyTerminal;
import AppliedIntegrations.Items.Part.ItemPartInteractionBus;
import AppliedIntegrations.Items.Part.Mana.ItemPartManaInterface;
import AppliedIntegrations.Items.Part.Mana.ItemPartManaStorageBus;
import AppliedIntegrations.Items.Part.P2P.ItemPartP2PEmber;
import AppliedIntegrations.Items.Part.P2P.ItemPartP2PMana;
import AppliedIntegrations.Items.Part.P2P.ItemPartP2PWill;
import AppliedIntegrations.Items.StorageCells.EnergyStorageCell;
import AppliedIntegrations.Items.StorageCells.EnergyStorageComponent;
import AppliedIntegrations.Items.StorageCells.ManaStorageCell;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ItemEnum {
    ITEMPARTIMPORT(new ItemPartEnergyImport("energyImportPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTEXPORT(new ItemPartEnergyExport("energyExportPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTSTORAGE(new ItemPartEnergyStorage("energyStoragePartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTINTERFACE(new ItemPartEnergyInterface("energyInterfacePartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTMONITOR(new ItemPartEnergyStorageMonitor("energyMonitorPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTTERMINAL(new ItemPartEnergyTerminal("energyTerminalPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTANNIHILATION(new ItemPartEnergyAnnihilation("energyAnnihilationPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTFORMATION(new ItemPartEnergyFormation("energyFormationPartItem"), AIConfig.enableEnergyFeatures),
    ITEMPARTINTERACTIONBUS(new ItemPartInteractionBus("interaction_bus"), AIConfig.enableInteractionPart),
    ITEMP2PEMBER(new ItemPartP2PEmber("emberP2PPartItem"), EmberLoader.enableEmber()),
    ITEMP2PWILL(new ItemPartP2PWill("willP2PPartItem"), BloodMagicLoader.enableWill()),
    ITEMMANAPARTINTERFACE(new ItemPartManaInterface("manaInterfacePartItem"), BotaniaLoader.enableBotania()),
    ITEMMANAPARTSTORAGEBUS(new ItemPartManaStorageBus("manaStoragePartItem"), BotaniaLoader.enableBotania()),
    ITEMP2PMANA(new ItemPartP2PMana("manaP2PPartItem"), BotaniaLoader.enableBotania()),
    ITEMMANAWIRELESSMIRROR(new MEManaMirror("me_mana_mirror"), BotaniaLoader.enableBotania()),
    ITEMENCORIUMSEED(new MaterialEncoriumSeed("encorium_seed"), BotaniaLoader.enableBotania()),
    ITEMENCORIUMDUST(new MaterialEncoriumDust("encorium_dust"), BotaniaLoader.enableBotania()),
    ITEMENCORIUM(new MaterialEncorium("encorium"), BotaniaLoader.enableBotania()),
    ITEMENERGYWIRELESSTERMINAL(new ItemEnergyWirelessTerminal("wireless_energy_terminal"), AIConfig.enableEnergyFeatures),
    CHAOSMANIPULATOR(new AdvancedNetworkTool("advancedWrench"), true),
    MEGRAPHTOOL(new GraphTool("graph_tool"), AIConfig.enableWebServer),
    MENETWORK_CARD(new NetworkCard("network_card"), AIConfig.enableMEServer),
    ENERGYSTORAGE_1k(new EnergyStorageCell("EnergyStorageCell_1k", 1024), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGE_4k(new EnergyStorageCell("EnergyStorageCell_4k", 4096), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGE_16k(new EnergyStorageCell("EnergyStorageCell_16k", 16384), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGE_64k(new EnergyStorageCell("EnergyStorageCell_64k", 65536), AIConfig.enableEnergyFeatures),
    MANASTORAGE_1k(new ManaStorageCell("ManaStorageCell_1k", 1024), BotaniaLoader.enableBotania()),
    MANASTORAGE_4k(new ManaStorageCell("ManaStorageCell_4k", 4096), BotaniaLoader.enableBotania()),
    MANASTORAGE_16k(new ManaStorageCell("ManaStorageCell_16k", 16384), BotaniaLoader.enableBotania()),
    MANASTORAGE_64k(new ManaStorageCell("ManaStorageCell_64k", 65536), BotaniaLoader.enableBotania()),
    MANAANNIHILATIONCORE(new ManaAnnihilationCore("mana_annihilation_core"), BotaniaLoader.enableBotania()),
    MANAFORMATIONCORE(new ManaFormationCore("mana_formation_core"), BotaniaLoader.enableBotania()),
    ENERGYSTORAGECOMPONENT_1k(new EnergyStorageComponent("EnergyStorageComponent_1k"), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGECOMPONENT_4k(new EnergyStorageComponent("EnergyStorageComponent_4k"), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGECOMPONENT_16k(new EnergyStorageComponent("EnergyStorageComponent_16k"), AIConfig.enableEnergyFeatures),
    ENERGYSTORAGECOMPONENT_64k(new EnergyStorageComponent("EnergyStorageComponent_64k"), AIConfig.enableEnergyFeatures);

    private boolean enabled;
    private Item item;

    private ItemEnum(AIItemRegistrable _item, boolean enabled) {
        this(_item, AppliedIntegrations.AI, enabled);
    }

    private ItemEnum(AIItemRegistrable _item, CreativeTabs creativeTab, boolean enabled) {
        this.item = _item;
        this.item.func_77637_a(creativeTab);
        this.enabled = enabled;
    }

    public static void register() {
        for (ItemEnum itemEnum : ItemEnum.values()) {
            if (!itemEnum.enabled) continue;
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemEnum.item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (ItemEnum item : ItemEnum.values()) {
            if (!item.enabled || !(item.item instanceof AIItemRegistrable)) continue;
            AIItemRegistrable registrableItem = (AIItemRegistrable)item.item;
            registrableItem.registerModel();
        }
    }

    public ItemStack getDamagedStack(int damage) {
        return this.getDMGStack(damage, 1);
    }

    public ItemStack getStack() {
        return new ItemStack(this.item);
    }

    public ItemStack getDMGStack(int damageValue, int size) {
        return new ItemStack(this.item, size, damageValue);
    }

    public Item getItem() {
        return this.item;
    }
}

