/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items.Botania;

import AppliedIntegrations.Integration.Botania.IBotaniaIntegrated;
import AppliedIntegrations.Items.ItemEnergyWirelessTerminal;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.BaseActionSource;
import appeng.util.Platform;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.botania.api.mana.IManaItem", modid="botania", striprefs=true), @Optional.Interface(iface="vazkii.botania.api.mana.IManaTooltipDisplay", modid="botania", striprefs=true)})
public class MEManaMirror
extends ItemEnergyWirelessTerminal
implements IAEItemPowerStorage,
INetworkEncodable,
IBotaniaIntegrated,
IManaItem,
IManaTooltipDisplay {
    private static final double ENERGY_CONSUMPTION_PER_MANA = 0.005;
    private static final String TAG_X = "#pos_X";
    private static final String TAG_Y = "#pos_Y";
    private static final String TAG_Z = "#pos_Z";
    private static final String TAG_W = "#world";

    public MEManaMirror(String registry) {
        super(registry);
    }

    private IStorageChannel<IAEManaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class);
    }

    private IMEMonitor<IAEManaStack> getManaInventory(IGrid targetGrid) {
        IStorageGrid storage = (IStorageGrid)targetGrid.getCache(IStorageGrid.class);
        return storage.getInventory(this.getChannel());
    }

    private boolean cantDoWork(ItemStack stack, IGrid grid) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        return this.isNotInRange(stack, grid, new BlockPos(tag.func_74769_h(TAG_X), tag.func_74769_h(TAG_Y), tag.func_74769_h(TAG_Z)), tag.func_74762_e(TAG_W));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
            tag.func_74780_a(TAG_X, player.field_70165_t);
            tag.func_74780_a(TAG_Y, player.field_70163_u);
            tag.func_74780_a(TAG_Z, player.field_70161_v);
            tag.func_74768_a(TAG_W, player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public int getMana(ItemStack stack) {
        IGrid grid = this.getGrid(stack);
        if (grid == null) {
            return 0;
        }
        if (this.cantDoWork(stack, grid)) {
            return 0;
        }
        IMEMonitor<IAEManaStack> inventory = this.getManaInventory(grid);
        IItemList list = inventory.getStorageList();
        IAEManaStack manaStack = (IAEManaStack)list.getFirstItem();
        if (manaStack != null) {
            int extractableManaCount = (int)(this.getAECurrentPower(stack) / 0.005);
            int stackSize = (int)manaStack.getStackSize();
            return Math.min(stackSize, extractableManaCount);
        }
        return 0;
    }

    public void addMana(ItemStack stack, int mana) {
        IGrid grid = this.getGrid(stack);
        if (grid == null) {
            return;
        }
        if (this.cantDoWork(stack, grid)) {
            return;
        }
        double extracted = this.extractAEPower(stack, (double)Math.abs(mana) * 0.005, Actionable.SIMULATE);
        if (extracted > 0.0) {
            this.extractAEPower(stack, (double)Math.abs(mana) * 0.005, Actionable.MODULATE);
            mana = (mana < 0 ? -1 : 1) * (int)(extracted / 0.005);
            IMEMonitor<IAEManaStack> inventory = this.getManaInventory(grid);
            if (mana < 0) {
                inventory.extractItems(this.getChannel().createStack((Object)Math.abs(mana)), Actionable.MODULATE, (IActionSource)new BaseActionSource());
            } else if (mana > 0) {
                inventory.injectItems(this.getChannel().createStack((Object)Math.abs(mana)), Actionable.MODULATE, (IActionSource)new BaseActionSource());
            }
        }
    }

    public int getMaxMana(ItemStack stack) {
        return this.getMana(stack);
    }

    public boolean canReceiveManaFromPool(ItemStack itemStack, TileEntity tileEntity) {
        return false;
    }

    public boolean canReceiveManaFromItem(ItemStack itemStack, ItemStack itemStack1) {
        return false;
    }

    public boolean canExportManaToPool(ItemStack itemStack, TileEntity tileEntity) {
        return true;
    }

    public boolean canExportManaToItem(ItemStack itemStack, ItemStack itemStack1) {
        return true;
    }

    public boolean isNoExport(ItemStack itemStack) {
        return false;
    }

    public float getManaFractionForDisplay(ItemStack itemStack) {
        return (float)this.getMana(itemStack) / (float)this.getMaxMana(itemStack);
    }

    @Override
    public boolean canHandle(ItemStack itemStack) {
        return itemStack.func_77973_b() == ItemEnum.ITEMMANAWIRELESSMIRROR.getItem();
    }
}

