/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items.Botania.Encorium;

import AppliedIntegrations.Integration.Botania.IBotaniaIntegrated;
import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.Items.ItemEnum;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.EntityGrowingCrystal;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MaterialEncoriumSeed
extends AIItemRegistrable
implements IBotaniaIntegrated,
IGrowableCrystal {
    private static final int LEVEL_STEP = 200;
    private static final int SINGLE_STEP = 600;

    public MaterialEncoriumSeed(String registry) {
        super(registry);
        this.func_185043_a(new ResourceLocation("growth"), (stack, worldIn, entityIn) -> {
            double progress = this.getProgressPercent(stack);
            return (float)(progress / 100.0);
        });
    }

    private int getProgress(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p().func_74762_e("progress");
        }
        int progress = is.func_77952_i();
        NBTTagCompound tag = Platform.openNbtData((ItemStack)is);
        tag.func_74768_a("progress", progress);
        is.func_77964_b(is.func_77952_i() / 600 * 600);
        return progress;
    }

    private void setProgress(ItemStack is, int newDamage) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)is);
        tag.func_74768_a("progress", newDamage);
        is.func_77964_b(is.func_77952_i() / 600 * 600);
    }

    private double getProgressPercent(ItemStack stack) {
        return Math.floor((float)(this.getProgress(stack) % 600) / 6.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        lines.add(ButtonToolTips.DoesntDespawn.getLocal());
        lines.add(this.getProgressPercent(stack) + "%");
        lines.add("");
        lines.add(TextFormatting.GOLD + "Design by MegaTech");
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1200;
    }

    public ItemStack triggerGrowth(ItemStack is) {
        int newDamage = this.getProgress(is) + 1;
        if (newDamage == 600) {
            return new ItemStack(ItemEnum.ITEMENCORIUM.getItem());
        }
        if (newDamage > 1200) {
            return ItemStack.field_190927_a;
        }
        this.setProgress(is, newDamage);
        return is;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityGrowingCrystal egc = new EntityGrowingCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        egc.field_70159_w = location.field_70159_w;
        egc.field_70181_x = location.field_70181_x;
        egc.field_70179_y = location.field_70179_y;
        egc.func_174867_a(40);
        return egc;
    }

    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }
}

