/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Inventory.Manager;

import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.api.IInventoryHost;
import AppliedIntegrations.api.ISyncHost;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.YesNo;
import java.util.function.Predicate;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeInventoryManager
implements IInventoryHost {
    private static final String KEY_FILTER_SIZE = "#FILTER_SIZE";
    private static final String KEY_RED_CONTROLLED = "#RED_CONTROLLER";
    private static final String KEY_INVERTED = "#INVERTED";
    private static final String KEY_AUTO_CRAFTING = "#AUTO_CRAFTING";
    private static final String KEY_FUZZY_COMPARE = "#FUZZY_COMPARE";
    private static final String KEY_REDSTONE_MODE = "#REDSTONE_MODE";
    private static final String KEY_FUZZY_MODE = "#FUZZY_MODE";
    private static final String KEY_SPEED_COUNT = "#UPGRADE_SPEED_COUNT";
    private static final String KEY_CRAFT_ONLY = "#CRAFT_ONLY";
    private final ISyncHost host;
    public AIGridNodeInventory upgradeInventory;
    public byte filterSize;
    public boolean redstoneControlled;
    public boolean inverted;
    public int upgradeSpeedCount;
    public boolean fuzzyCompare;
    public boolean autoCrafting;
    public RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    public FuzzyMode fuzzyMode = FuzzyMode.IGNORE_ALL;
    public YesNo craftOnly = YesNo.NO;

    public UpgradeInventoryManager(ISyncHost host, String name, int size) {
        this(host, name, size, stack -> true);
    }

    public UpgradeInventoryManager(ISyncHost host, String name, int size, final Predicate<ItemStack> isItemValid) {
        this.host = host;
        this.upgradeInventory = new AIGridNodeInventory(name, size, 1, this){

            @Override
            public boolean func_94041_b(int i, ItemStack itemStack) {
                return isItemValid.test(itemStack);
            }
        };
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a(KEY_FILTER_SIZE, this.filterSize);
        nbt.func_74768_a(KEY_SPEED_COUNT, this.upgradeSpeedCount);
        nbt.func_74757_a(KEY_RED_CONTROLLED, this.redstoneControlled);
        nbt.func_74757_a(KEY_INVERTED, this.inverted);
        nbt.func_74757_a(KEY_AUTO_CRAFTING, this.autoCrafting);
        nbt.func_74757_a(KEY_FUZZY_COMPARE, this.fuzzyCompare);
        nbt.func_74774_a(KEY_REDSTONE_MODE, (byte)this.redstoneMode.ordinal());
        nbt.func_74774_a(KEY_FUZZY_MODE, (byte)this.fuzzyMode.ordinal());
        nbt.func_74774_a(KEY_CRAFT_ONLY, (byte)this.craftOnly.ordinal());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.filterSize = nbt.func_74771_c(KEY_FILTER_SIZE);
        this.upgradeSpeedCount = nbt.func_74762_e(KEY_SPEED_COUNT);
        this.redstoneControlled = nbt.func_74767_n(KEY_RED_CONTROLLED);
        this.inverted = nbt.func_74767_n(KEY_INVERTED);
        this.autoCrafting = nbt.func_74767_n(KEY_AUTO_CRAFTING);
        this.fuzzyCompare = nbt.func_74767_n(KEY_FUZZY_COMPARE);
        this.redstoneMode = RedstoneMode.values()[nbt.func_74771_c(KEY_REDSTONE_MODE)];
        this.fuzzyMode = FuzzyMode.values()[nbt.func_74771_c(KEY_FUZZY_MODE)];
        this.craftOnly = YesNo.values()[nbt.func_74771_c(KEY_CRAFT_ONLY)];
    }

    @Override
    public void onInventoryChanged() {
        this.filterSize = 0;
        this.redstoneControlled = false;
        this.inverted = false;
        this.fuzzyCompare = false;
        this.autoCrafting = false;
        this.upgradeSpeedCount = 0;
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack currentStack = this.upgradeInventory.func_70301_a(i);
            if (currentStack.func_77973_b() == Items.field_190931_a) continue;
            if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(currentStack)) {
                this.filterSize = (byte)(this.filterSize + 1);
            }
            if (AEApi.instance().definitions().materials().cardSpeed().isSameAs(currentStack)) {
                ++this.upgradeSpeedCount;
            }
            if (AEApi.instance().definitions().materials().cardRedstone().isSameAs(currentStack)) {
                this.redstoneControlled = true;
            }
            if (AEApi.instance().definitions().materials().cardInverter().isSameAs(currentStack)) {
                this.inverted = true;
            }
            if (AEApi.instance().definitions().materials().cardFuzzy().isSameAs(currentStack)) {
                this.fuzzyCompare = true;
            }
            if (!AEApi.instance().definitions().materials().cardCrafting().isSameAs(currentStack)) continue;
            this.autoCrafting = true;
        }
    }

    public void acceptVal(Enum val) {
        if (val instanceof RedstoneMode) {
            this.redstoneMode = (RedstoneMode)val;
        } else if (val instanceof FuzzyMode) {
            this.fuzzyMode = (FuzzyMode)val;
        } else if (val instanceof YesNo) {
            this.craftOnly = (YesNo)val;
        }
    }
}

