/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Inventory.Handlers;

import AppliedIntegrations.Helpers.Energy.CapabilityHelper;
import AppliedIntegrations.Parts.Energy.PartEnergyStorage;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnumCapabilityType;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.List;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;

public class HandlerEnergyStorageBusContainer
implements IMEInventoryHandler<IAEEnergyStack> {
    private TileEntity storage;
    private EnumCapabilityType type;
    private PartEnergyStorage owner;

    public HandlerEnergyStorageBusContainer(PartEnergyStorage owner, TileEntity operand, EnumCapabilityType type) {
        this.storage = operand;
        this.type = type;
        this.owner = owner;
    }

    public static boolean listContainsNonNullValues(List<LiquidAIEnergy> filteredEnergies) {
        return filteredEnergies.stream().allMatch(Objects::isNull);
    }

    public IAEEnergyStack injectItems(IAEEnergyStack input, Actionable type, IActionSource src) {
        if (this.getAccess() == AccessRestriction.READ) {
            return input;
        }
        if (input == null) {
            return null;
        }
        if (!input.isMeaningful()) {
            return input;
        }
        if (!HandlerEnergyStorageBusContainer.listContainsNonNullValues(this.owner.filteredEnergies) && !this.owner.filteredEnergies.contains((Object)input.getEnergy())) {
            return input;
        }
        CapabilityHelper helper = new CapabilityHelper(this.storage, this.owner.getHostSide().getOpposite());
        int added = helper.receiveEnergy(input.getStackSize(), type == Actionable.SIMULATE, this.type.energy);
        int notAdded = (int)input.getStackSize() - added;
        if (notAdded > 0) {
            return (IAEEnergyStack)((IAEEnergyStack)input.copy()).setStackSize(notAdded);
        }
        return null;
    }

    public IAEEnergyStack extractItems(IAEEnergyStack request, Actionable mode, IActionSource src) {
        if (this.getAccess() == AccessRestriction.WRITE) {
            return null;
        }
        if (request == null) {
            return null;
        }
        if (!request.isMeaningful()) {
            return null;
        }
        if (!HandlerEnergyStorageBusContainer.listContainsNonNullValues(this.owner.filteredEnergies) && !this.owner.filteredEnergies.contains((Object)request.getEnergy())) {
            return null;
        }
        CapabilityHelper helper = new CapabilityHelper(this.storage, this.owner.getHostSide().getOpposite());
        int extracted = helper.extractEnergy(request.getStackSize(), mode == Actionable.SIMULATE, this.type.energy);
        if (extracted > 0) {
            return (IAEEnergyStack)((IAEEnergyStack)request.copy()).setStackSize(extracted);
        }
        return null;
    }

    public IItemList<IAEEnergyStack> getAvailableItems(IItemList<IAEEnergyStack> out) {
        if (this.getAccess() == AccessRestriction.WRITE) {
            return null;
        }
        CapabilityHelper helper = new CapabilityHelper(this.storage, this.owner.getHostSide().getOpposite());
        int stored = helper.getStored(this.type.energy);
        out.add((IAEStack)AEEnergyStack.fromStack(new EnergyStack(this.type.energy, stored)));
        return out;
    }

    public IStorageChannel<IAEEnergyStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
    }

    public AccessRestriction getAccess() {
        return this.owner.access;
    }

    public boolean isPrioritized(IAEEnergyStack input) {
        return false;
    }

    public boolean canAccept(IAEEnergyStack input) {
        return this.storage != null;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }
}

