/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Helpers;

import AppliedIntegrations.Container.part.ContainerEnergyInterface;
import AppliedIntegrations.Helpers.Energy.CapabilityHelper;
import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketBarChange;
import AppliedIntegrations.Network.Packets.PartGUI.PacketProgressBar;
import AppliedIntegrations.Parts.Energy.PartEnergyInterface;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IEnergyInterfaceDuality;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.EnumCapabilityType;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import AppliedIntegrations.tile.TileEnergyInterface;
import appeng.api.config.Actionable;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import java.util.LinkedList;
import java.util.List;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class EnergyInterfaceDuality
implements IEnergyInterfaceDuality {
    private IEnergyInterface owner;
    private List<LiquidAIEnergy> initializedStorages = new LinkedList<LiquidAIEnergy>();

    public EnergyInterfaceDuality(IEnergyInterface owner) {
        this.owner = owner;
        this.initializedStorages.add(AIEnergy.RF);
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            this.initializedStorages.add(AIEnergy.EU);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false)) {
            this.initializedStorages.add(AIEnergy.J);
        }
    }

    public <T> T getCapability(Capability<T> capability, AEPartLocation side) {
        if (capability == appeng.capabilities.Capabilities.FORGE_ENERGY) {
            return (T)this.getEnergyStorage(AIEnergy.RF, side);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY) {
            return (T)this.getEnergyStorage(AIEnergy.J, side);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability) {
        if (capability == appeng.capabilities.Capabilities.FORGE_ENERGY) {
            return true;
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false)) {
            return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY;
        }
        return false;
    }

    public void initStorage(AEPartLocation side) {
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            if (!IntegrationsHelper.instance.isLoaded(energy, false)) continue;
            this.owner.initEnergyStorage(energy, side);
        }
    }

    public void notifyListenersOfEnergyBarChange(LiquidAIEnergy energy, AEPartLocation energySide) {
        for (ContainerEnergyInterface listener : this.owner.getListeners()) {
            TileEnergyInterface hostTile;
            if (listener == null || (hostTile = this.owner instanceof PartEnergyInterface ? ((PartEnergyInterface)this.owner).getHostTile() : (TileEnergyInterface)this.owner) == null) continue;
            NetworkHandler.sendTo(new PacketProgressBar(this.owner, energySide, (Number)this.getEnergyStorage(energy, energySide).getStored()), (EntityPlayerMP)listener.player);
        }
    }

    public void notifyListenersOfBarFilterChange(LiquidAIEnergy bar) {
        for (ContainerEnergyInterface listener : this.owner.getListeners()) {
            if (listener == null) continue;
            NetworkHandler.sendTo(new PacketBarChange(bar, this.owner), (EntityPlayerMP)listener.player);
        }
    }

    private boolean isStorageInitialized(LiquidAIEnergy energy) {
        return this.initializedStorages.contains((Object)energy);
    }

    @Override
    public double getMaxTransfer(AEPartLocation side) {
        return this.owner.getMaxTransfer(side);
    }

    @Override
    public LiquidAIEnergy getFilteredEnergy(AEPartLocation side) {
        return this.owner.getFilteredEnergy(side);
    }

    @Override
    public IInterfaceStorageDuality getEnergyStorage(LiquidAIEnergy energy, AEPartLocation side) {
        return this.owner.getEnergyStorage(energy, side);
    }

    @Override
    public void doInjectDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        IGridNode node = this.owner.getGridNode();
        if (node == null) {
            throw new NullNodeConnectionException();
        }
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            if (action == Actionable.MODULATE) {
                for (EnumCapabilityType energyType : EnumCapabilityType.values) {
                    int extractedAmount;
                    int valuedReceive;
                    int injectedAmount;
                    IInterfaceStorageDuality energyStorage;
                    int stored;
                    LiquidAIEnergy energy = energyType.energy;
                    if (!this.isStorageInitialized(energy) || (stored = ((Number)(energyStorage = this.getEnergyStorage(energy, side)).getStored()).intValue()) <= 0 || this.getFilteredEnergy(side) == energy || (injectedAmount = this.owner.injectEnergy(new EnergyStack(energy, valuedReceive = (int)Math.min((double)stored, this.getMaxTransfer(side))), Actionable.SIMULATE)) <= 0 || (extractedAmount = ((Number)energyStorage.extract(energyStorage.toNativeValue(injectedAmount), Actionable.SIMULATE)).intValue()) <= 0) continue;
                    this.owner.setLastInjectedEnergy(side, energy);
                    this.owner.injectEnergy(new EnergyStack(energy, extractedAmount), Actionable.MODULATE);
                    energyStorage.extract(energyStorage.toNativeValue(extractedAmount), Actionable.MODULATE);
                }
            }
            if (!(this.owner instanceof TileEnergyInterface)) break;
        }
    }

    @Override
    public void doExtractDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        IGridNode node = this.owner.getGridNode();
        if (node == null) {
            throw new NullNodeConnectionException();
        }
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            LiquidAIEnergy filteredEnergy;
            if (action == Actionable.MODULATE && (filteredEnergy = this.getFilteredEnergy(side)) != null) {
                Class t = this.getEnergyStorage(filteredEnergy, side).getTypeClass();
                IInterfaceStorageDuality interfaceStorageDuality = this.getEnergyStorage(filteredEnergy, side);
                if (t != Long.class) {
                    int extractedAmount;
                    int stored = ((Number)interfaceStorageDuality.getStored()).intValue();
                    int capacity = ((Number)interfaceStorageDuality.getMaxStored()).intValue();
                    int valuedExtract = Math.min(capacity - stored, (int)this.getMaxTransfer(side));
                    int injectedAmount = ((Number)interfaceStorageDuality.receive(interfaceStorageDuality.toNativeValue(valuedExtract), Actionable.SIMULATE)).intValue();
                    if (injectedAmount > 0 && (extractedAmount = this.owner.extractEnergy(new EnergyStack(filteredEnergy, injectedAmount), Actionable.SIMULATE)) > 0) {
                        interfaceStorageDuality.receive(interfaceStorageDuality.toNativeValue(extractedAmount), Actionable.MODULATE);
                        this.owner.extractEnergy(new EnergyStack(filteredEnergy, extractedAmount), Actionable.MODULATE);
                        this.transferEnergy(filteredEnergy, Math.min(stored, Math.min((int)this.getMaxTransfer(side), 50000)), side.getFacing().func_176734_d());
                    }
                }
            }
            if (!(this.owner instanceof TileEnergyInterface)) break;
        }
    }

    private void transferEnergy(LiquidAIEnergy filteredEnergy, int amount, EnumFacing side) {
        TileEntity tile = this.owner.getFacingTile(side);
        if (tile == null) {
            return;
        }
        if (filteredEnergy == null) {
            return;
        }
        for (EnumCapabilityType type : EnumCapabilityType.values) {
            if (!tile.hasCapability(type.getInputCapability(), side)) continue;
            CapabilityHelper capabilityHelper = new CapabilityHelper(tile, AEPartLocation.fromFacing((EnumFacing)side));
            this.getEnergyStorage(filteredEnergy, AEPartLocation.fromFacing((EnumFacing)side)).modifyEnergyStored(-capabilityHelper.receiveEnergy(amount, false, filteredEnergy));
        }
    }
}

