/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Helpers.Energy;

import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.EnumCapabilityType;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.util.AEPartLocation;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.comp.Energy;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import java.util.Vector;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class CapabilityHelper {
    private final AEPartLocation side;
    private TileEntity capabilityHandler;
    private Vector<Capability> capabilities = new Vector();
    private Vector<Class> hostClasses = new Vector();

    public CapabilityHelper(TileEntity capabilityHandler, AEPartLocation side) {
        this.capabilityHandler = capabilityHandler;
        this.side = side;
        if (capabilityHandler != null) {
            for (EnumCapabilityType capabilityType : EnumCapabilityType.values) {
                if (capabilityType == null) continue;
                if (capabilityType.getCapabilityWithModCheck() != null) {
                    for (Capability capability : capabilityType.getCapabilityWithModCheck()) {
                        if (!capabilityHandler.hasCapability(capability, side.getFacing())) continue;
                        this.capabilities.add(capability);
                    }
                }
                if (capabilityType.getHostClassesWithModCheck() == null) continue;
                for (Class clazz : capabilityType.getHostClassesWithModCheck()) {
                    if (!clazz.isInstance(capabilityHandler)) continue;
                    this.hostClasses.add(clazz);
                }
            }
        }
    }

    public int getMaxStored(LiquidAIEnergy energy) {
        for (Capability capability : EnumCapabilityType.fromEnergy((LiquidAIEnergy)energy).capabilities) {
            if (!this.capabilities.contains(capability)) continue;
            if (capability == CapabilityEnergy.ENERGY) {
                net.minecraftforge.energy.IEnergyStorage energyStorageCapability = (net.minecraftforge.energy.IEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return energyStorageCapability.getMaxEnergyStored();
            }
            if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && capability == Capabilities.ENERGY_STORAGE_CAPABILITY) {
                IStrictEnergyStorage storage = (IStrictEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return (int)storage.getMaxEnergy();
            }
            if (!IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false) || capability != TeslaCapabilities.CAPABILITY_HOLDER) continue;
            ITeslaHolder teslaHolderCapability = (ITeslaHolder)this.capabilityHandler.getCapability(capability, this.side.getFacing());
            return (int)teslaHolderCapability.getCapacity();
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            if (this.capabilityHandler instanceof TileEntityElectricMachine) {
                Capability capability;
                TileEntityElectricMachine electricMachine = (TileEntityElectricMachine)this.capabilityHandler;
                capability = (Energy)electricMachine.getComponent(Energy.class);
                return (int)capability.getCapacity();
            }
            if (this.capabilityHandler instanceof IEnergyStorage) {
                IEnergyStorage iEnergyStorage = (IEnergyStorage)this.capabilityHandler;
                return iEnergyStorage.getCapacity();
            }
        }
        return 0;
    }

    public int getStored(LiquidAIEnergy energy) {
        if (energy == null) {
            return 0;
        }
        if (EnumCapabilityType.fromEnergy(energy) == null) {
            return 0;
        }
        for (Capability capability : EnumCapabilityType.fromEnergy((LiquidAIEnergy)energy).capabilities) {
            if (!this.capabilities.contains(capability)) continue;
            if (capability == CapabilityEnergy.ENERGY) {
                net.minecraftforge.energy.IEnergyStorage energyStorageCapability = (net.minecraftforge.energy.IEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return energyStorageCapability.getEnergyStored();
            }
            if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && capability == Capabilities.ENERGY_STORAGE_CAPABILITY) {
                IStrictEnergyStorage storage = (IStrictEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return (int)storage.getEnergy();
            }
            if (!IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false) || capability != TeslaCapabilities.CAPABILITY_HOLDER) continue;
            ITeslaHolder teslaHolderCapability = (ITeslaHolder)this.capabilityHandler.getCapability(capability, this.side.getFacing());
            return (int)teslaHolderCapability.getStoredPower();
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            if (this.capabilityHandler instanceof TileEntityElectricMachine) {
                Capability capability;
                TileEntityElectricMachine electricMachine = (TileEntityElectricMachine)this.capabilityHandler;
                capability = (Energy)electricMachine.getComponent(Energy.class);
                return (int)capability.getEnergy();
            }
            if (this.capabilityHandler instanceof IEnergyStorage) {
                IEnergyStorage iEnergyStorage = (IEnergyStorage)this.capabilityHandler;
                return iEnergyStorage.getStored();
            }
        }
        return 0;
    }

    public int receiveEnergy(Number val, boolean simulate, LiquidAIEnergy energy) {
        int intVal = val.intValue();
        for (Capability capability : EnumCapabilityType.fromEnergy((LiquidAIEnergy)energy).capabilities) {
            if (!this.capabilities.contains(capability)) continue;
            if (capability == CapabilityEnergy.ENERGY) {
                net.minecraftforge.energy.IEnergyStorage energyStorageCapability = (net.minecraftforge.energy.IEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return energyStorageCapability.receiveEnergy(intVal, simulate);
            }
            if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY) {
                IStrictEnergyAcceptor storage = (IStrictEnergyAcceptor)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return (int)storage.acceptEnergy(this.side.getFacing(), val.doubleValue(), !simulate);
            }
            if (!IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false) || capability != TeslaCapabilities.CAPABILITY_CONSUMER) continue;
            ITeslaConsumer teslaHolderCapability = (ITeslaConsumer)this.capabilityHandler.getCapability(capability, this.side.getFacing());
            return (int)teslaHolderCapability.givePower(val.longValue(), simulate);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            if (this.capabilityHandler instanceof TileEntityElectricMachine) {
                Capability capability;
                TileEntityElectricMachine electricMachine = (TileEntityElectricMachine)this.capabilityHandler;
                capability = (Energy)electricMachine.getComponent(Energy.class);
                double added = capability.addEnergy((double)intVal);
                if (simulate) {
                    capability.addEnergy(-added);
                }
                return (int)added;
            }
            if (this.capabilityHandler instanceof IEnergyStorage) {
                IEnergyStorage iEnergyStorage = (IEnergyStorage)this.capabilityHandler;
                int storedBefore = iEnergyStorage.getStored();
                iEnergyStorage.addEnergy(intVal);
                int storedAfter = iEnergyStorage.getStored();
                if (simulate) {
                    iEnergyStorage.setStored(storedBefore);
                }
                return storedAfter - storedBefore;
            }
        }
        return 0;
    }

    public int extractEnergy(Number val, boolean simulate, LiquidAIEnergy energy) {
        if (energy == null) {
            return 0;
        }
        if (EnumCapabilityType.fromEnergy(energy) == null) {
            return 0;
        }
        int intVal = val.intValue();
        for (Capability capability : EnumCapabilityType.fromEnergy((LiquidAIEnergy)energy).capabilities) {
            if (!this.capabilities.contains(capability)) continue;
            if (capability == CapabilityEnergy.ENERGY) {
                net.minecraftforge.energy.IEnergyStorage energyStorageCapability = (net.minecraftforge.energy.IEnergyStorage)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return energyStorageCapability.extractEnergy(intVal, simulate);
            }
            if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY) {
                IStrictEnergyOutputter storage = (IStrictEnergyOutputter)this.capabilityHandler.getCapability(capability, this.side.getFacing());
                return (int)storage.pullEnergy(this.side.getFacing(), val.doubleValue(), simulate);
            }
            if (!IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false) || capability != TeslaCapabilities.CAPABILITY_PRODUCER) continue;
            ITeslaProducer teslaHolderCapability = (ITeslaProducer)this.capabilityHandler.getCapability(capability, this.side.getFacing());
            return (int)teslaHolderCapability.takePower(val.longValue(), simulate);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            if (this.capabilityHandler instanceof TileEntityElectricMachine) {
                Capability capability;
                TileEntityElectricMachine electricMachine = (TileEntityElectricMachine)this.capabilityHandler;
                capability = (Energy)electricMachine.getComponent(Energy.class);
                if (capability.getEnergy() < (double)intVal) {
                    return 0;
                }
                double added = capability.addEnergy((double)(-intVal));
                if (simulate) {
                    capability.addEnergy(-added);
                }
                return (int)added;
            }
            if (this.capabilityHandler instanceof IEnergyStorage) {
                IEnergyStorage iEnergyStorage = (IEnergyStorage)this.capabilityHandler;
                if (iEnergyStorage.getStored() < intVal) {
                    return 0;
                }
                int storedBefore = iEnergyStorage.getStored();
                iEnergyStorage.addEnergy(-intVal);
                int storedAfter = iEnergyStorage.getStored();
                if (simulate) {
                    iEnergyStorage.setStored(storedBefore);
                }
                return storedAfter - storedBefore;
            }
        }
        return 0;
    }

    public long extractAllStored(int max) {
        int extracted = 0;
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            extracted += this.extractEnergy(Math.min(this.getStored(energy), max), false, energy);
        }
        return extracted;
    }

    public boolean operatesEnergy(LiquidAIEnergy energy) {
        if (EnumCapabilityType.fromEnergy(energy) == null) {
            return false;
        }
        EnumCapabilityType type = EnumCapabilityType.fromEnergy(energy);
        if (type == null) {
            return false;
        }
        if (type.getCapabilityWithModCheck() != null) {
            for (Capability capability : this.capabilities) {
                for (Capability otherCapability : type.getCapabilityWithModCheck()) {
                    if (!capability.equals(otherCapability)) continue;
                    return true;
                }
            }
        }
        if (type.getHostClassesWithModCheck() != null) {
            for (Class clazz : this.hostClasses) {
                for (Class otherClazz : type.getHostClassesWithModCheck()) {
                    if (!clazz.equals(otherClazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

