/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container;

import AppliedIntegrations.Container.ContainerWithPlayerInventory;
import AppliedIntegrations.Container.slot.SlotRestrictive;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import appeng.api.implementations.items.IUpgradeModule;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerWithUpgradeSlots
extends ContainerWithPlayerInventory {
    private static int UPGRADE_Y_POSITION_MULTIPLIER = 18;
    protected boolean hasNetworkTool = false;
    private int firstToolSlotNumber = -1;
    private int lastToolSlotNumber = -1;
    private int firstUpgradeSlot = -1;
    private int lastUpgradeSlot = -1;

    public ContainerWithUpgradeSlots(EntityPlayer player) {
        super(player);
    }

    protected void addUpgradeSlots(AIGridNodeInventory upgradeInventory, int count, int xPosition, int yPosition) {
        SlotRestrictive upgradeSlot = null;
        for (int slotIndex = 0; slotIndex < count; ++slotIndex) {
            upgradeSlot = new SlotRestrictive(upgradeInventory, slotIndex, xPosition, yPosition + slotIndex * UPGRADE_Y_POSITION_MULTIPLIER){

                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return "appliedintegrations:gui/slots/upgradesloticon";
                }
            };
            this.func_75146_a(upgradeSlot);
            if (slotIndex != 0) continue;
            this.firstUpgradeSlot = upgradeSlot.field_75222_d;
        }
        if (upgradeSlot != null) {
            this.lastUpgradeSlot = upgradeSlot.field_75222_d;
        }
    }

    public boolean hasNetworkTool() {
        return this.hasNetworkTool;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        boolean merged = false;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                merged = this.mergeSlotWithUpgrades(slotStack);
                if (!merged) {
                    merged = this.mergeSlotWithNetworkTool(slotStack);
                }
                if (!merged) {
                    merged = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else if (this.slotClickedWasInUpgrades(slotNumber)) {
                merged = this.mergeSlotWithNetworkTool(slotStack);
                if (!merged) {
                    merged = this.mergeSlotWithPlayerInventory(slotStack);
                }
            } else if (this.hasNetworkTool && this.slotClickedWasInNetworkTool(slotNumber) && !(merged = this.mergeSlotWithUpgrades(slotStack))) {
                merged = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (!merged) {
                return new ItemStack(Items.field_190931_a);
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(new ItemStack(Items.field_190931_a));
            }
            slot.func_75218_e();
            this.func_75142_b();
        }
        return new ItemStack(Items.field_190931_a);
    }

    protected boolean mergeSlotWithUpgrades(ItemStack slotStack) {
        if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
            return false;
        }
        boolean didMerge = false;
        for (int index = this.firstUpgradeSlot; index <= this.lastUpgradeSlot; ++index) {
            Slot upgradeSlot = (Slot)this.field_75151_b.get(index);
            if (upgradeSlot == null || upgradeSlot.func_75216_d() || !upgradeSlot.func_75214_a(slotStack)) continue;
            ItemStack upgradeStack = slotStack.func_77946_l();
            upgradeStack.func_190920_e(1);
            upgradeSlot.func_75215_d(upgradeStack);
            slotStack.func_190920_e(slotStack.func_190916_E() - 1);
            didMerge = true;
            if (slotStack.func_190916_E() == 0) break;
        }
        return didMerge;
    }

    protected boolean mergeSlotWithNetworkTool(ItemStack slotStack) {
        if (this.hasNetworkTool) {
            if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
                return false;
            }
            return this.func_75135_a(slotStack, this.firstToolSlotNumber, this.lastToolSlotNumber + 1, false);
        }
        return false;
    }

    protected boolean slotClickedWasInUpgrades(int slotNumber) {
        return slotNumber >= this.firstUpgradeSlot && slotNumber <= this.lastUpgradeSlot;
    }

    protected boolean slotClickedWasInNetworkTool(int slotNumber) {
        return this.hasNetworkTool && slotNumber >= this.firstToolSlotNumber && slotNumber <= this.lastToolSlotNumber;
    }
}

