/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container;

import AppliedIntegrations.Container.AIContainer;
import AppliedIntegrations.Container.slot.SlotToggle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class ContainerWithPlayerInventory
extends AIContainer {
    protected static final int SLOT_SIZE = 18;
    private static final int INVENTORY_X_OFFSET = 8;
    private static int ROWS = 3;
    private static int COLUMNS = 9;
    protected final SlotToggle[] hotbarSlots = new SlotToggle[COLUMNS];
    protected final SlotToggle[] playerSlots = new SlotToggle[COLUMNS * ROWS];

    public ContainerWithPlayerInventory(EntityPlayer player) {
        super(player);
    }

    protected final boolean swapSlotInventoryHotbar(int slotNumber, ItemStack slotStack) {
        if (this.slotClickedWasInHotbarInventory(slotNumber)) {
            return this.mergeSlotWithPlayerInventory(slotStack);
        }
        if (this.slotClickedWasInPlayerInventory(slotNumber)) {
            return this.mergeSlotWithHotbarInventory(slotStack);
        }
        return false;
    }

    protected final boolean slotClickedWasInHotbarInventory(int slotNumber) {
        return slotNumber >= this.hotbarSlots[0].field_75222_d && slotNumber <= this.hotbarSlots[ContainerWithPlayerInventory.COLUMNS - 1].field_75222_d;
    }

    protected final boolean mergeSlotWithPlayerInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.playerSlots[0].field_75222_d, this.playerSlots[ContainerWithPlayerInventory.COLUMNS * ContainerWithPlayerInventory.ROWS - 1].field_75222_d + 1, false);
    }

    protected final boolean slotClickedWasInPlayerInventory(int slotNumber) {
        return slotNumber >= this.playerSlots[0].field_75222_d && slotNumber <= this.playerSlots[ContainerWithPlayerInventory.COLUMNS * ContainerWithPlayerInventory.ROWS - 1].field_75222_d;
    }

    protected final boolean mergeSlotWithHotbarInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.hotbarSlots[0].field_75222_d, this.hotbarSlots[ContainerWithPlayerInventory.COLUMNS - 1].field_75222_d + 1, false);
    }

    public final void bindPlayerInventory(IInventory playerInventory, int inventoryOffsetY, int hotbarPositionY) {
        for (int column = 0; column < COLUMNS; ++column) {
            this.hotbarSlots[column] = new SlotToggle(playerInventory, column, 8 + column * 18, hotbarPositionY);
            this.func_75146_a(this.hotbarSlots[column]);
        }
        for (int row = 0; row < ROWS; ++row) {
            for (int column = 0; column < COLUMNS; ++column) {
                int index = column + row * COLUMNS;
                this.playerSlots[index] = new SlotToggle(playerInventory, COLUMNS + index, 8 + column * 18, row * 18 + inventoryOffsetY);
                this.func_75146_a(this.playerSlots[index]);
            }
        }
    }
}

