/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Integration.Botania.BotaniaLoader;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.Proxy.CommonProxy;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="appliedintegrations", name="Applied Integrations", version="8.0.16.7", dependencies="required-after:appliedenergistics2", acceptedMinecraftVersions="[1.12.2]")
public class AppliedIntegrations {
    public static final String version = "8.0.16.7";
    public static final String phase = "beta";
    public static final String modid = "appliedintegrations";
    @Mod.Instance(value="appliedintegrations")
    public static AppliedIntegrations instance;
    public static CreativeTabs AI;
    @SidedProxy(clientSide="AppliedIntegrations.Proxy.ClientProxy", serverSide="AppliedIntegrations.Proxy.CommonProxy")
    public static CommonProxy proxy;

    public AppliedIntegrations() {
        instance = this;
    }

    public static AppliedIntegrations getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public static void metadata(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.autogenerated = false;
        meta.modId = modid;
        meta.name = "Applied Integrations";
        meta.version = "beta8.0.16.7";
        meta.logoFile = "logo.png";
        meta.authorList.add("Azazell ( azazellfn@gmail.com )");
        meta.description = "Addon for Applied Energistics 2 for storing energy, mana. And some network things";
        meta.url = "https://github.com/AzazeII/Applied-Integrations/";
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AIConfig.preInit();
        if (AIConfig.enableEnergyFeatures) {
            for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
                FluidRegistry.registerFluid((Fluid)energy);
            }
        }
        if (AppliedIntegrations.getLogicalSide() == Side.CLIENT) {
            PartModelEnum.registerModels();
        }
        proxy.SidedPreInit();
        AILog.info("Pre load Completed", new Object[0]);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerSpatialIOMovables();
        proxy.SidedInit(event);
        if (Loader.isModLoaded((String)"botania") && AIConfig.enableManaFeatures) {
            BotaniaLoader.initRecipes();
        }
        FMLCommonHandler.instance().bus().register((Object)instance);
        AILog.info("init Completed", new Object[0]);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new AIGuiHandler());
        AILog.info("Post load Completed", new Object[0]);
    }

    public static Side getLogicalSide() {
        Thread thr = Thread.currentThread();
        if (thr.getName().equals("Server thread")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    static {
        AI = new CreativeTabs(I18n.func_74838_a((String)modid)){

            public ItemStack func_78016_d() {
                return new ItemStack(ItemEnum.CHAOSMANIPULATOR.getItem(), 1);
            }
        };
    }
}

