/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class RenderItemEnergyCrystal
implements IItemRenderer {
    private CCModel crystalFull;
    private CCModel crystalHalf;
    private CCModel crystalBase;
    private static ShaderProgram shaderProgram;
    private static float[] r;
    private static float[] g;
    private static float[] b;

    public RenderItemEnergyCrystal() {
        Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal.obj"));
        this.crystalFull = CCModel.combine(map.values());
        map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal_half.obj"));
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public void renderItem(ItemStack item, ItemCameraTransforms.TransformType transformType) {
        EnergyCrystal.CrystalType type = EnergyCrystal.CrystalType.fromMeta(item.func_77952_i());
        int tier = EnergyCrystal.CrystalType.getTier(item.func_77952_i());
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        CCRenderState ccrs = CCRenderState.instance();
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(0.5, type == EnergyCrystal.CrystalType.CRYSTAL_IO ? 0.0 : 0.5, 0.5), (Rotation)new Rotation(0.0, 0.0, 0.0, 0.0), (double)1.0);
        ResourceHelperDE.bindTexture("textures/models/crystal_purple_transparent.png");
        if (type == EnergyCrystal.CrystalType.CRYSTAL_IO) {
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            mat.apply((Transformation)new Rotation((double)((float)ClientEventHandler.elapsedTicks / 400.0f), 0.0, 1.0, 0.0));
            ResourceHelperDE.bindTexture("textures/models/reactor_core.png");
            this.bindShader(0.0f, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        } else {
            this.bindShader(0.0f, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        }
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public void bindShader(float partialTicks, int tier) {
        if (DEShaders.useShaders()) {
            if (shaderProgram == null) {
                shaderProgram = new ShaderProgram();
                shaderProgram.attachShader(DEShaders.energyCrystal_V);
                shaderProgram.attachShader(DEShaders.energyCrystal_F);
            }
            shaderProgram.useShader(cache -> {
                cache.glUniform1F("time", ((float)ClientEventHandler.elapsedTicks + partialTicks) / 50.0f);
                cache.glUniform1F("mipmap", 0.0f);
                cache.glUniform1I("type", tier);
                cache.glUniform2F("angle", 0.0f, 0.0f);
            });
        } else {
            ResourceHelperDE.bindTexture("textures/models/crystal_no_shader.png");
            GlStateManager.func_179124_c((float)r[tier], (float)g[tier], (float)b[tier]);
        }
    }

    private void releaseShader() {
        if (DEShaders.useShaders()) {
            shaderProgram.releaseShader();
        }
    }

    static {
        r = new float[]{0.0f, 0.47f, 1.0f};
        g = new float[]{0.2f, 0.0f, 0.4f};
        b = new float[]{0.3f, 0.58f, 0.1f};
    }
}

