/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ExplosionFX
extends BCParticle {
    public static CCModel model;
    public static CCModel model_inv;
    public CoreEffect coreEffect;
    private LinkedList<EffectPart> effectParts = new LinkedList();
    private static final Random rand;
    private static ShaderProgram leadingWaveProgram;
    private static ShaderProgram blastWaveProgram;
    private static ShaderProgram coreEffectProgram;
    public final int radius;
    public static final IGLFXHandler FX_HANDLER;

    public ExplosionFX(World worldIn, Vec3D pos, int radius) {
        super(worldIn, pos);
        this.radius = radius;
        this.field_70547_e = 240;
        this.coreEffect = new CoreEffect(0.0);
    }

    public boolean isRawGLParticle() {
        return true;
    }

    public void func_189213_a() {
        int age;
        if (this.effectParts.size() > 0) {
            Iterator i = this.effectParts.iterator();
            while (i.hasNext()) {
                EffectPart part = (EffectPart)i.next();
                if (part.isDead()) {
                    i.remove();
                    continue;
                }
                part.update();
            }
        }
        this.coreEffect.update();
        if (this.field_70546_d > this.field_70547_e) {
            this.func_187112_i();
        }
        if ((age = this.field_70546_d) == 0) {
            this.coreEffect = new CoreEffect(0.0);
            ClientEventHandler.triggerExplosionEffect(this.getPos().getPos());
        } else if (age == 3 || age == 8 || age == 13) {
            this.effectParts.addFirst(new LeadingWave(age));
        } else if (age > 30 && age <= 35) {
            this.effectParts.addFirst(new BlastWave(age - 30));
        }
        if (age == 10) {
            this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, DESoundHandler.fusionExplosion, SoundCategory.PLAYERS, 100.0f, 0.9f, false);
        }
        ++this.field_70546_d;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Vec3D pos = new Vec3D(this.field_187126_f - field_70556_an, this.field_187127_g - field_70554_ao, this.field_187128_h - field_70555_ap);
        CCRenderState ccrs = CCRenderState.instance();
        float ttl = 1.0f - ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        ttl = Math.min(1.0f, ttl * 5.0f);
        double od = 1200.0;
        double id = (double)this.radius / 100.0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f * ttl * Math.min(1.0f, (float)this.field_70547_e / 25.0f)));
        ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < 8; ++i) {
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(od, id * (double)i, od));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            od += id * (double)i;
        }
        ccrs.draw();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.coreEffect.isDead()) {
            this.coreEffect.render(pos, ccrs, partialTicks);
        }
        for (EffectPart part : this.effectParts) {
            part.render(pos, ccrs, partialTicks);
        }
    }

    public IGLFXHandler getFXHandler() {
        return FX_HANDLER;
    }

    static {
        rand = new Random();
        Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/block/obj_models/reactor_core.obj"));
        model = CCModel.combine(map.values());
        model_inv = model.backfacedCopy();
        FX_HANDLER = new IGLFXHandler(){

            public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179090_x();
                if (!DEShaders.useShaders()) {
                    GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
                    GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                }
            }

            public void postDraw(int layer, BufferBuilder vertexbuffer, Tessellator tessellator) {
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179098_w();
                GlStateManager.func_179089_o();
                if (!DEShaders.useShaders()) {
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
            }
        };
    }

    private class CoreEffect
    extends EffectPart {
        public CoreEffect(double scale) {
            super(scale);
            this.maxAge = 60;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)(ExplosionFX.this.radius / 6) * ttl * 2.0f;
            float a = (float)this.age + partialTicks;
            if (coreEffectProgram == null) {
                coreEffectProgram = new ShaderProgram();
                coreEffectProgram.attachShader(DEShaders.explosionCoreEffect);
            }
            coreEffectProgram.useShader(cache -> {
                cache.glUniform1F("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
                cache.glUniform1F("scale", a > 35.0f ? (a - 35.0f) / 20.0f * 2.0f : 0.0f);
                cache.glUniform1F("alpha", a > 50.0f ? 1.0f - (a - 50.0f) / 10.0f : 1.0f);
            });
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, scale / 2.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            coreEffectProgram.releaseShader();
        }
    }

    private class BlastWave
    extends EffectPart {
        public BlastWave(double scale) {
            super(scale);
            this.maxAge = 150 + (int)(scale * 5.0);
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            double vScale = (double)((float)(ExplosionFX.this.radius / 5) * ttl) * this.scale;
            float a = (float)this.age + partialTicks;
            if (blastWaveProgram == null) {
                blastWaveProgram = new ShaderProgram();
                blastWaveProgram.attachShader(DEShaders.explosionBlastWave);
            }
            blastWaveProgram.useShader(cache -> {
                cache.glUniform1F("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
                cache.glUniform1F("scale", ttl);
                cache.glUniform1F("alpha", a < 40.0f ? (a - 20.0f) / 20.0f : 1.0f - ttl);
            });
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, vScale, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            blastWaveProgram.releaseShader();
        }
    }

    private class LeadingWave
    extends EffectPart {
        public LeadingWave(double scale) {
            super(scale);
            this.maxAge = 40 + (int)scale;
        }

        @Override
        public void update() {
            if (this.age > this.maxAge) {
                this.setDead();
            }
            ++this.age;
        }

        @Override
        public void render(Vec3D pos, CCRenderState ccrs, float partialTicks) {
            float ttl = ((float)this.age + partialTicks) / (float)this.maxAge;
            double scale = (float)ExplosionFX.this.radius * ttl * 2.0f;
            if (leadingWaveProgram == null) {
                leadingWaveProgram = new ShaderProgram();
                leadingWaveProgram.attachShader(DEShaders.explosionLeadingWave);
            }
            leadingWaveProgram.useShader(cache -> {
                cache.glUniform1F("time", ((float)ClientEventHandler.elapsedTicks + partialTicks + (float)this.randOffset) / 10.0f);
                cache.glUniform1F("scale", ttl * 3.0f);
                cache.glUniform1F("alpha", 1.0f - ttl);
            });
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)pos.toVector3(), (Rotation)new Rotation(0.0, 0.0, 1.0, 0.0), (double)1.0).apply((Transformation)new Scale(scale, 1.0, scale));
            model_inv.render(ccrs, new IVertexOperation[]{mat});
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            leadingWaveProgram.releaseShader();
        }
    }

    private static abstract class EffectPart {
        private boolean isDead = false;
        protected int age = 0;
        protected int maxAge = 0;
        public double scale;
        public int randOffset;

        public EffectPart(double scale) {
            this.scale = scale;
            this.randOffset = rand.nextInt(3265324);
        }

        public abstract void update();

        public abstract void render(Vec3D var1, CCRenderState var2, float var3);

        public void setDead() {
            this.isDead = true;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

