/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki;

import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IScrollListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiListEntry;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiScrollBar;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.guielements.WikiTreeButton;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WikiContentList
extends MGuiList
implements IMGuiListener {
    private GuiModWiki guiModWiki;
    private MGuiLabel navLabel;
    private MGuiLabel branchLabel;
    private MGuiButtonSolid buttonToggleNav;
    private LinkedList<WikiTreeButton> treeButtons = new LinkedList();
    public List<ToAdd> toAddList = Collections.synchronizedList(new ArrayList());
    private MGuiButtonSolid buttonAddBranch;
    private boolean navUpdateRequired = true;
    public boolean isHidden = false;
    private int maxXSize = 150;

    public WikiContentList(GuiModWiki parentGui) {
        super((IModularGui)parentGui);
        this.guiModWiki = parentGui;
        this.topPadding = 24;
        this.leftPadding = 12;
        this.bottomPadding = 2;
    }

    public void initElement() {
        this.toRemove.addAll(this.childElements);
        this.buttonToggleNav = ((MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "TOGGLE_PANEL", this.xSize - 11, this.yPos + 1, 10, 10, "<"){

            public int getTextColour(boolean hovered, boolean disabled) {
                return 1.mixColours((int)WikiConfig.NAV_WINDOW, (int)(hovered ? 0x606060 : 0x404040));
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Navigation Window"})).setColours(0, 0, 0);
        this.addChild((MGuiElementBase)this.buttonToggleNav);
        this.navLabel = new MGuiLabel(this.modularGui, this.xPos, this.yPos, this.xSize, 12, I18n.func_135052_a((String)"guiwiki.label.navigation", (Object[])new Object[0])){

            public int getTextColour() {
                return WikiConfig.TEXT_COLOUR;
            }
        }.setAlignment(EnumAlignment.LEFT).setShadow(false);
        this.addChild((MGuiElementBase)this.navLabel);
        this.branchLabel = new MGuiLabel(this.modularGui, this.xPos + 12, this.yPos + 12, this.maxXSize - 12, 12, I18n.func_135052_a((String)"guiwiki.label.mods", (Object[])new Object[0])){

            public int getTextColour() {
                return WikiConfig.TEXT_COLOUR;
            }
        }.setShadow(false);
        this.addChild((MGuiElementBase)this.branchLabel);
        this.buttonAddBranch = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "ADD_BRANCH", this.xPos + this.maxXSize - 40, this.yPos, 28, 12, "[\u00a74add\u00a7r]"){

            public int getTextColour(boolean hovered, boolean disabled) {
                return hovered ? 0xFFFFFF : -16777216;
            }
        }.setColours(0, 0, 0).setShadow(false);
        this.addChild((MGuiElementBase)this.buttonAddBranch);
        this.buttonAddBranch.setListener((IMGuiListener)this).setToolTip(new String[]{"Add new sub-branch to the selected branch", "Adds a new mod branch if on the Mods branch", "Otherwise adds a new sub branch."}).setEnabled(false);
        this.branchLabel.trim = true;
        super.initElement();
        this.updateHiddenState();
        this.updateNavButtons();
    }

    protected void initScrollBar() {
        if (this.scrollBar != null) {
            this.removeChild((MGuiElementBase)this.scrollBar);
        }
        this.scrollBar = new MGuiScrollBar(this.modularGui, this.xPos + this.xSize - 5, this.yPos + 23, 6, this.ySize - 24){

            public int getScrollColour() {
                return 5.mixColours((int)WikiConfig.NAV_WINDOW, (int)0x505050);
            }
        };
        this.addChild((MGuiElementBase)this.scrollBar);
        this.scrollBar.setListener((IScrollListener)this);
        this.scrollBar.parentScrollable = this;
        this.scrollBar.borderColour = 0;
        this.scrollBar.backColour = 0;
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int navWindowColour = WikiConfig.NAV_WINDOW;
        int neg10 = WikiContentList.mixColours((int)navWindowColour, (int)0x101010, (boolean)true);
        int pos10 = WikiContentList.mixColours((int)navWindowColour, (int)0x101010);
        int pos15 = WikiContentList.mixColours((int)navWindowColour, (int)0x151515);
        int neg15 = WikiContentList.mixColours((int)navWindowColour, (int)0x151515, (boolean)true);
        int pos20 = WikiContentList.mixColours((int)navWindowColour, (int)0x202020);
        this.drawColouredRect(this.xPos, this.yPos, this.xSize, this.ySize, navWindowColour);
        this.drawColouredRect(this.xPos + this.xSize, this.yPos, 0.5, this.ySize, neg10);
        this.drawColouredRect(this.xPos, this.yPos, this.xSize, 12.0, pos10);
        this.drawColouredRect(this.xPos, this.yPos, this.xSize, 0.5, pos20);
        this.drawColouredRect(this.xPos, (double)this.yPos + 11.5, this.xSize, 0.5, neg10);
        this.drawColouredRect((double)this.xPos + 11.5, this.yPos + 12, 0.5, this.ySize - 12, neg15);
        this.drawColouredRect(this.xPos + 12, this.yPos + 12, 0.5, this.ySize - 12, pos15);
        this.drawColouredRect(this.xPos, this.yPos + 12, this.xSize, 0.5, pos20);
        this.drawColouredRect(this.xPos + 12, (double)this.yPos + 23.5, this.xSize - 12, 0.5, neg10);
        this.drawColouredRect(this.xPos + 12, this.yPos + this.ySize - 2, this.xSize - 12, 2.0, neg15);
        if (!this.isHidden && this.scrollBar.isEnabled() && GuiHelper.isInRect((int)this.scrollBar.xPos, (int)this.scrollBar.yPos, (int)this.scrollBar.xSize, (int)this.scrollBar.ySize, (int)mouseX, (int)mouseY)) {
            this.drawColouredRect(this.xPos + this.xSize - 4, this.yPos + 24, 4.0, this.ySize - 24, WikiContentList.mixColours((int)this.scrollBar.scrollColour, (int)-872415232, (boolean)true));
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void onMGuiEvent(String event, MGuiElementBase element) {
        if (element == this.buttonToggleNav) {
            this.isHidden = !this.isHidden;
            this.updateHiddenState();
        } else if (element == this.buttonAddBranch) {
            this.guiModWiki.wikiDataTree.getActiveBranch().createNewSubBranch();
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        for (MGuiElementBase element : this.nonListEntries) {
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        for (MGuiElementBase element : this.listEntries) {
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            this.navUpdateRequired = true;
            return true;
        }
        return false;
    }

    public boolean onUpdate() {
        this.checkAddQue();
        if (this.navUpdateRequired) {
            this.navUpdateRequired = false;
            this.updateNavButtons();
        }
        return super.onUpdate();
    }

    private void updateHiddenState() {
        this.scrollBar.setEnabled(!this.isHidden && this.scrollBarEnabled);
        this.scrollBar.xPos = this.xPos + this.maxXSize - 5;
        this.navLabel.setEnabled(!this.isHidden);
        this.branchLabel.setEnabled(!this.isHidden);
        this.buttonAddBranch.setEnabled(!this.isHidden && WikiConfig.editMode);
        this.xSize = this.isHidden ? 12 : this.maxXSize;
        this.buttonToggleNav.xPos = this.xSize - 11;
        this.buttonToggleNav.displayString = this.isHidden ? ">" : "<";
        this.disableList = this.isHidden;
        this.guiModWiki.updateWindowPositions();
        this.guiModWiki.contentWindow.setActiveBranch(this.guiModWiki.wikiDataTree.getActiveBranch());
    }

    public void updateNavButtons() {
        int height;
        TreeBranchRoot branch = this.guiModWiki.wikiDataTree.getActiveBranch().parent;
        this.removeChildByGroup("TREE_BUTTON_GROUP");
        this.treeButtons.clear();
        int currentLength = 0;
        while (branch != null && currentLength + (height = this.guiModWiki.getMinecraft().field_71466_p.func_78256_a(branch.branchName) + 6) <= this.yPos + this.ySize - this.bottomPadding) {
            WikiTreeButton newButton = new WikiTreeButton(this.modularGui, this.xPos, this.yPos + 12, 12, height, branch.branchName, branch);
            newButton.addToGroup("TREE_BUTTON_GROUP");
            this.addChild((MGuiElementBase)newButton);
            for (WikiTreeButton button : this.treeButtons) {
                button.yPos += height;
                if (button.yPos + button.ySize <= currentLength) continue;
                currentLength = button.yPos + button.ySize;
            }
            this.treeButtons.add(newButton);
            branch = branch.parent;
        }
    }

    public void reloadList() {
        this.clear();
        for (TreeBranchRoot branch : this.guiModWiki.wikiDataTree.getActiveList()) {
            this.addEntry(branch);
        }
        this.branchLabel.setDisplayString(this.guiModWiki.wikiDataTree.getActiveBranch().branchName);
        this.updateNavButtons();
    }

    public MGuiList addEntry(MGuiListEntry entry) {
        entry.xSize = this.maxXSize - this.leftPadding - this.rightPadding - 4;
        return super.addEntry(entry);
    }

    public int getListEntryWidth() {
        return this.maxXSize - this.rightPadding - this.leftPadding;
    }

    private void checkAddQue() {
        if (this.toAddList.isEmpty()) {
            return;
        }
        for (ToAdd toAdd : this.toAddList) {
            Document doc = toAdd.branch.branchData.getOwnerDocument();
            Element subBranch = doc.createElement("entry");
            subBranch.setAttribute("name", toAdd.name);
            subBranch.setAttribute("branchId", toAdd.branch.branchID + (toAdd.branch.isModBranch ? ":" : "/") + toAdd.id);
            subBranch.setAttribute("iconType", "off");
            if (!StringUtils.func_151246_b((String)toAdd.category)) {
                subBranch.setAttribute("category", toAdd.category);
            }
            toAdd.branch.branchData.appendChild(subBranch);
            try {
                WikiDocManager.writeXMLToFile(doc, WikiDocManager.documentToFileMap.get(doc));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            WikiDocManager.reload(true, true, true);
            if (!this.guiModWiki.wikiDataTree.idToBranchMap.containsKey(toAdd.branch.branchID)) continue;
            this.guiModWiki.wikiDataTree.setActiveBranch(this.guiModWiki.wikiDataTree.idToBranchMap.get(toAdd.branch.branchID));
        }
        this.toAddList.clear();
    }

    public static class ToAdd {
        public final String name;
        public final String id;
        public final String category;
        public final TreeBranchRoot branch;

        public ToAdd(String name, String id, String category, TreeBranchRoot branch) {
            this.name = name;
            this.id = id;
            this.category = category;
            this.branch = branch;
        }
    }
}

