/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.xnet.XNet;
import mcjty.xnet.clientinfo.ConnectedBlockClientInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketConnectedBlocksReady
implements IMessage {
    public BlockPos pos;
    public List<ConnectedBlockClientInfo> list;
    public String command;

    public PacketConnectedBlocksReady() {
    }

    public PacketConnectedBlocksReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketConnectedBlocksReady(BlockPos pos, String command, List<ConnectedBlockClientInfo> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<ConnectedBlockClientInfo>();
        this.list.addAll(list);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<ConnectedBlockClientInfo>(size);
            for (int i = 0; i < size; ++i) {
                ConnectedBlockClientInfo item = new ConnectedBlockClientInfo(buf);
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (ConnectedBlockClientInfo item : this.list) {
                item.writeToBuf(buf);
            }
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = XNet.proxy.getClientWorld().func_175625_s(this.pos);
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(ConnectedBlockClientInfo.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

