/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.clientinfo;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.network.NetworkTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.clientinfo.ConnectorClientInfo;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class ChannelClientInfo {
    @Nonnull
    private final IChannelType type;
    @Nonnull
    private final IChannelSettings channelSettings;
    @Nonnull
    private final String channelName;
    private final boolean enabled;
    private final Map<SidedConsumer, ConnectorClientInfo> connectors = new HashMap<SidedConsumer, ConnectorClientInfo>();

    public ChannelClientInfo(@Nonnull String channelName, @Nonnull IChannelType type, @Nonnull IChannelSettings channelSettings, boolean enabled) {
        this.channelName = channelName;
        this.type = type;
        this.channelSettings = channelSettings;
        this.enabled = enabled;
    }

    public ChannelClientInfo(@Nonnull ByteBuf buf) {
        this.channelName = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.enabled = buf.readBoolean();
        String id = NetworkTools.readString((ByteBuf)buf);
        IChannelType t = XNet.xNetApi.findType(id);
        if (t == null) {
            throw new RuntimeException("Bad type: " + id);
        }
        this.type = t;
        this.channelSettings = this.type.createChannel();
        NBTTagCompound tag = NetworkTools.readTag((ByteBuf)buf);
        this.channelSettings.readFromNBT(tag);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            SidedConsumer key = new SidedConsumer(new ConsumerId(buf.readInt()), EnumFacing.field_82609_l[buf.readByte()]);
            ConnectorClientInfo info = new ConnectorClientInfo(buf);
            this.connectors.put(key, info);
        }
    }

    public void writeToNBT(@Nonnull ByteBuf buf) {
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.channelName);
        buf.writeBoolean(this.enabled);
        NetworkTools.writeString((ByteBuf)buf, (String)this.type.getID());
        NBTTagCompound tag = new NBTTagCompound();
        this.channelSettings.writeToNBT(tag);
        NetworkTools.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        buf.writeInt(this.connectors.size());
        for (Map.Entry<SidedConsumer, ConnectorClientInfo> entry : this.connectors.entrySet()) {
            SidedConsumer key = entry.getKey();
            ConnectorClientInfo info = entry.getValue();
            buf.writeInt(key.getConsumerId().getId());
            buf.writeByte(key.getSide().ordinal());
            info.writeToBuf(buf);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public IChannelType getType() {
        return this.type;
    }

    @Nonnull
    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    @Nonnull
    public Map<SidedConsumer, ConnectorClientInfo> getConnectors() {
        return this.connectors;
    }
}

