/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.definitions.IBlockDefinition;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRendering;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.AEConfig;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.TileDefinition;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

class BlockDefinitionBuilder
implements IBlockBuilder {
    private final FeatureFactory factory;
    private final String registryName;
    private final Supplier<? extends Block> blockSupplier;
    private final List<BiFunction<Block, Item, IBootstrapComponent>> bootstrapComponents = new ArrayList<BiFunction<Block, Item, IBootstrapComponent>>();
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private CreativeTabs creativeTab = CreativeTab.instance;
    private TileEntityDefinition tileEntityDefinition;
    private boolean disableItem = false;
    private Function<Block, ItemBlock> itemFactory;
    @SideOnly(value=Side.CLIENT)
    private BlockRendering blockRendering;
    @SideOnly(value=Side.CLIENT)
    private ItemRendering itemRendering;

    BlockDefinitionBuilder(FeatureFactory factory, String id, Supplier<? extends Block> blockSupplier) {
        this.factory = factory;
        this.registryName = id;
        this.blockSupplier = blockSupplier;
        if (Platform.isClient()) {
            this.blockRendering = new BlockRendering();
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public BlockDefinitionBuilder bootstrap(BiFunction<Block, Item, IBootstrapComponent> callback) {
        this.bootstrapComponents.add(callback);
        return this;
    }

    @Override
    public IBlockBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IBlockBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public BlockDefinitionBuilder rendering(BlockRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IBlockBuilder tileEntity(TileEntityDefinition tileEntityDefinition) {
        this.tileEntityDefinition = tileEntityDefinition;
        return this;
    }

    @Override
    public IBlockBuilder useCustomItemModel() {
        this.rendering(new BlockRenderingCustomizer(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
                ModelResourceLocation model = new ModelResourceLocation(new ResourceLocation("appliedenergistics2", BlockDefinitionBuilder.this.registryName), "inventory");
                itemRendering.model(model).variants(new ResourceLocation[]{model});
            }
        });
        return this;
    }

    @Override
    public IBlockBuilder item(Function<Block, ItemBlock> factory) {
        this.itemFactory = factory;
        return this;
    }

    @Override
    public IBlockBuilder disableItem() {
        this.disableItem = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(BlockRenderingCustomizer callback) {
        callback.customize(this.blockRendering, this.itemRendering);
    }

    @Override
    public <T extends IBlockDefinition> T build() {
        if (!AEConfig.instance().areFeaturesEnabled(this.features)) {
            return (T)new TileDefinition(this.registryName, null, null);
        }
        Block block = this.blockSupplier.get();
        block.setRegistryName("appliedenergistics2", this.registryName);
        block.func_149663_c("appliedenergistics2." + this.registryName);
        ItemBlock item = this.constructItemFromBlock(block);
        if (item != null) {
            item.setRegistryName("appliedenergistics2", this.registryName);
        }
        this.factory.addBootstrapComponent((side, registry) -> registry.register((IForgeRegistryEntry)block));
        if (item != null) {
            this.factory.addBootstrapComponent((side, registry) -> registry.register((IForgeRegistryEntry)item));
        }
        block.func_149647_a(this.creativeTab);
        this.bootstrapComponents.forEach(component -> this.factory.addBootstrapComponent((IBootstrapComponent)component.apply(block, item)));
        if (this.tileEntityDefinition != null && block instanceof AEBaseTileBlock) {
            ((AEBaseTileBlock)block).setTileEntity(this.tileEntityDefinition.getTileEntityClass());
            if (this.tileEntityDefinition.getName() == null) {
                this.tileEntityDefinition.setName(this.registryName);
            }
        }
        if (Platform.isClient()) {
            if (block instanceof AEBaseTileBlock) {
                AEBaseTileBlock tileBlock = (AEBaseTileBlock)block;
                this.blockRendering.apply(this.factory, block, tileBlock.getTileEntityClass());
            } else {
                this.blockRendering.apply(this.factory, block, null);
            }
            if (item != null) {
                this.itemRendering.apply(this.factory, (Item)item);
            }
        }
        if (block instanceof AEBaseTileBlock) {
            this.factory.addBootstrapComponent(side -> AEBaseTile.registerTileItem(this.tileEntityDefinition == null ? ((AEBaseTileBlock)block).getTileEntityClass() : this.tileEntityDefinition.getTileEntityClass(), new BlockStackSrc(block, 0, ActivityState.Enabled)));
            if (this.tileEntityDefinition != null) {
                this.factory.tileEntityComponent.addTileEntity(this.tileEntityDefinition);
            }
            return (T)new TileDefinition(this.registryName, (AEBaseTileBlock)block, item);
        }
        return (T)new BlockDefinition(this.registryName, block, item);
    }

    @Nullable
    private ItemBlock constructItemFromBlock(Block block) {
        if (this.disableItem) {
            return null;
        }
        if (this.itemFactory != null) {
            return this.itemFactory.apply(block);
        }
        if (block instanceof AEBaseBlock) {
            return new AEBaseItemBlock(block);
        }
        return new ItemBlock(block);
    }
}

