/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.BlockPosHelpers;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleLiquidDrainer
extends ModuleWorker {
    public ModuleLiquidDrainer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 0;
    }

    @Override
    public boolean work() {
        return false;
    }

    public void handleLiquid(ModuleDrill drill, BlockPos pos) {
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        int result = this.drainAt(this.getCart().field_70170_p, drill, checked, pos, 0);
        if (result > 0 && this.doPreWork()) {
            drill.kill();
            this.startWorking((int)(2.5f * (float)result));
        } else {
            this.stopWorking();
        }
    }

    @Override
    public boolean preventAutoShutdown() {
        return true;
    }

    private int drainAt(World world, ModuleDrill drill, ArrayList<BlockPos> checked, BlockPos pos, int buckets) {
        int drained = 0;
        IBlockState blockState = world.func_180495_p(pos);
        Block b = blockState.func_177230_c();
        if (!this.isLiquid(b)) {
            return 0;
        }
        int meta = b.func_176201_c(blockState);
        FluidStack liquid = this.getFluidStack(b, pos, !this.doPreWork());
        if (liquid != null) {
            int amount;
            if (this.doPreWork()) {
                FluidStack fluidStack = liquid;
                fluidStack.amount += buckets * 1000;
            }
            if ((amount = this.getCart().fill(liquid, false)) == liquid.amount) {
                boolean isDrainable;
                boolean bl = isDrainable = meta == 0;
                if (!this.doPreWork()) {
                    if (isDrainable) {
                        this.getCart().fill(liquid, true);
                    }
                    world.func_175698_g(pos);
                }
                drained += isDrainable ? 40 : 3;
                buckets += isDrainable ? 1 : 0;
            }
        }
        checked.add(pos);
        if (checked.size() < 100 && BlockPosHelpers.getHorizontalDistToCartSquared(pos, this.getCart()) < 200.0) {
            for (int y = 1; y >= 0; --y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos next;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || checked.contains(next = pos.func_177982_a(x, y, z))) continue;
                        drained += this.drainAt(world, drill, checked, next, buckets);
                    }
                }
            }
        }
        return drained;
    }

    private boolean isLiquid(Block b) {
        boolean isWater = b == Blocks.field_150355_j || b == Blocks.field_150358_i || b == Blocks.field_150432_aD;
        boolean isLava = b == Blocks.field_150353_l || b == Blocks.field_150356_k;
        boolean isOther = b != null && b instanceof IFluidBlock;
        return isWater || isLava || isOther;
    }

    private FluidStack getFluidStack(Block b, BlockPos pos, boolean doDrain) {
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (b instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)b;
            return liquid.drain(this.getCart().field_70170_p, pos, doDrain);
        }
        return null;
    }
}

