/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.common.ColourRGBA;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum ConductorTier implements ITier
{
    BASIC(5.0, 1.0, 10.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
    ADVANCED(5.0, 1.0, 400.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
    ELITE(5.0, 1.0, 8000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
    ULTIMATE(5.0, 1.0, 100000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0));

    private final ColourRGBA baseColour;
    private final double baseConduction;
    private final double baseHeatCapacity;
    private final double baseConductionInsulation;
    private final BaseTier baseTier;

    private ConductorTier(double inversek, double inverseC, double insulationInversek, ColourRGBA colour) {
        this.baseConduction = inversek;
        this.baseHeatCapacity = inverseC;
        this.baseConductionInsulation = insulationInversek;
        this.baseColour = colour;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    public static ConductorTier get(BaseTier tier) {
        for (ConductorTier transmitter : ConductorTier.values()) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public double getInverseConduction() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorInverseConduction.val();
    }

    public double getInverseConductionInsulation() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorConductionInsulation.val();
    }

    public double getInverseHeatCapacity() {
        return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorHeatCapacity.val();
    }

    public ColourRGBA getBaseColour() {
        return this.baseColour;
    }

    public double getBaseConduction() {
        return this.baseConduction;
    }

    public double getBaseHeatCapacity() {
        return this.baseHeatCapacity;
    }

    public double getBaseConductionInsulation() {
        return this.baseConductionInsulation;
    }
}

