/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import mekanism.api.MekanismAPI;
import mekanism.api.util.BlockInfo;
import mekanism.common.Mekanism;
import net.minecraft.block.Block;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBoxBlacklist
implements IMessageHandler<BoxBlacklistMessage, IMessage> {
    public IMessage onMessage(BoxBlacklistMessage message, MessageContext context) {
        return null;
    }

    public static class BoxBlacklistMessage
    implements IMessage {
        public void toBytes(ByteBuf dataStream) {
            Set<BlockInfo> boxIgnore = MekanismAPI.getBoxIgnore();
            dataStream.writeInt(boxIgnore.size());
            for (BlockInfo info : boxIgnore) {
                dataStream.writeInt(Block.func_149682_b((Block)info.block));
                dataStream.writeInt(info.meta);
            }
            Set<String> boxModIgnore = MekanismAPI.getBoxModIgnore();
            dataStream.writeInt(boxModIgnore.size());
            for (String modid : boxModIgnore) {
                ByteBufUtils.writeUTF8String((ByteBuf)dataStream, (String)modid);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            MekanismAPI.getBoxIgnore().clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                MekanismAPI.addBoxBlacklist(Block.func_149729_e((int)dataStream.readInt()), dataStream.readInt());
            }
            int amountMods = dataStream.readInt();
            for (int i = 0; i < amountMods; ++i) {
                MekanismAPI.addBoxBlacklistMod(ByteBufUtils.readUTF8String((ByteBuf)dataStream));
            }
            Mekanism.logger.info("Received Cardboard Box blacklist entries from server (" + amount + " explicit blocks, " + amountMods + " mod wildcards)");
        }
    }
}

