/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.forgeenergy;

import mekanism.api.energy.IEnergizedItem;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyItemWrapper
extends ItemCapabilityWrapper.ItemCapability
implements IEnergyStorage {
    @Override
    public boolean canProcess(Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public IEnergizedItem getItem() {
        return (IEnergizedItem)this.getStack().func_77973_b();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.getItem().canReceive(this.getStack())) {
            int energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
            int toReceive = Math.min(maxReceive, energyNeeded);
            if (!simulate) {
                this.getItem().setEnergy(this.getStack(), this.getItem().getEnergy(this.getStack()) + ForgeEnergyIntegration.fromForge(toReceive));
            }
            return toReceive;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.getItem().canSend(this.getStack())) {
            int energyRemaining = this.getEnergyStored();
            int toSend = Math.min(maxExtract, energyRemaining);
            if (!simulate) {
                this.getItem().setEnergy(this.getStack(), this.getItem().getEnergy(this.getStack()) - ForgeEnergyIntegration.fromForge(toSend));
            }
            return toSend;
        }
        return 0;
    }

    public int getEnergyStored() {
        return ForgeEnergyIntegration.toForge(this.getItem().getEnergy(this.getStack()));
    }

    public int getMaxEnergyStored() {
        return ForgeEnergyIntegration.toForge(this.getItem().getMaxEnergy(this.getStack()));
    }

    public boolean canExtract() {
        return this.getItem().canSend(this.getStack());
    }

    public boolean canReceive() {
        return this.getItem().canReceive(this.getStack());
    }
}

