/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiTextFilterBase;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTextFilter<FILTER extends IFilter, TILE extends TileEntityContainerBlock>
extends GuiTextFilterBase<FILTER, TILE> {
    protected List<ItemStack> iterStacks;
    protected int stackSwitch;
    protected int stackIndex;
    protected GuiButton checkboxButton;

    protected GuiTextFilter(EntityPlayer player, TILE tile) {
        super(player, tile);
    }

    @Override
    protected boolean wasTextboxKey(char c, int i) {
        return TransporterFilter.SPECIAL_CHARS.contains(Character.valueOf(c)) || super.wasTextboxKey(c, i);
    }

    @Override
    protected GuiTextField createTextField() {
        return new GuiTextField(2, this.field_146289_q, this.field_147003_i + 35, this.field_147009_r + 47, 95, 12);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.text.func_146194_f();
        if (this.tileEntity instanceof TileEntityDigitalMiner && this.overReplaceOutput(xAxis, yAxis)) {
            GuiTextFilter.func_73734_a((int)(this.field_147003_i + 149), (int)(this.field_147009_r + 19), (int)(this.field_147003_i + 165), (int)(this.field_147009_r + 35), (int)-2130706433);
        }
        MekanismRenderer.resetColor();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.tileEntity instanceof TileEntityDigitalMiner) {
            this.drawMinerForegroundLayer(mouseX, mouseY, this.renderStack);
        } else if (this.tileEntity instanceof TileEntityLogisticalSorter) {
            this.drawTransporterForegroundLayer(mouseX, mouseY, this.renderStack);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setText();
        } else if (this.tileEntity instanceof TileEntityDigitalMiner && this.filter instanceof MinerFilter) {
            this.actionPerformedMinerCommon(guibutton, (MinerFilter)this.filter);
        } else if (this.tileEntity instanceof TileEntityLogisticalSorter && this.filter instanceof TransporterFilter) {
            this.actionPerformedTransporter(guibutton, (TransporterFilter)this.filter);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.text.func_146192_a(mouseX, mouseY, button);
        if (button == 0 && this.tileEntity instanceof TileEntityDigitalMiner && this.filter instanceof MinerFilter) {
            this.minerFilterClickCommon(mouseX - this.field_147003_i, mouseY - this.field_147009_r, (MinerFilter)this.filter);
        } else if (this.tileEntity instanceof TileEntityLogisticalSorter && this.filter instanceof TransporterFilter) {
            this.transporterMouseClicked(button, (TransporterFilter)this.filter);
        }
    }
}

