/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFormulaicAssemblicator
extends GuiMekanismTile<TileEntityFormulaicAssemblicator> {
    private GuiButton encodeFormulaButton;
    private GuiButton stockControlButton;
    private GuiButton fillEmptyButton;
    private GuiButton craftSingleButton;
    private GuiButton craftAvailableButton;
    private GuiButton autoModeButton;

    public GuiFormulaicAssemblicator(InventoryPlayer inventory, TileEntityFormulaicAssemblicator tile) {
        super(tile, new ContainerFormulaicAssemblicator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 159, 15));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityFormulaicAssemblicator)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityFormulaicAssemblicator)this.tileEntity).getMaxEnergy() - ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 151, 75).with(GuiSlot.SlotOverlay.POWER));
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.encodeFormulaButton = new GuiButtonDisableableImage(0, this.field_147003_i + 7, this.field_147009_r + 45, 14, 14, 176, 14, -14, 14, this.getGuiLocation());
        this.field_146292_n.add(this.encodeFormulaButton);
        this.stockControlButton = new GuiButtonDisableableImage(1, this.field_147003_i + 26, this.field_147009_r + 75, 16, 16, 238, 64, -16, 16, this.getGuiLocation());
        this.field_146292_n.add(this.stockControlButton);
        this.fillEmptyButton = new GuiButtonDisableableImage(2, this.field_147003_i + 44, this.field_147009_r + 75, 16, 16, 238, 16, -16, 16, this.getGuiLocation());
        this.field_146292_n.add(this.fillEmptyButton);
        this.craftSingleButton = new GuiButtonDisableableImage(3, this.field_147003_i + 71, this.field_147009_r + 75, 16, 16, 190, 16, -16, 16, this.getGuiLocation());
        this.field_146292_n.add(this.craftSingleButton);
        this.craftAvailableButton = new GuiButtonDisableableImage(4, this.field_147003_i + 89, this.field_147009_r + 75, 16, 16, 206, 16, -16, 16, this.getGuiLocation());
        this.field_146292_n.add(this.craftAvailableButton);
        this.autoModeButton = new GuiButtonDisableableImage(5, this.field_147003_i + 107, this.field_147009_r + 75, 16, 16, 222, 16, -16, 16, this.getGuiLocation());
        this.field_146292_n.add(this.autoModeButton);
        this.updateEnabledButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.encodeFormulaButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(1)));
        } else if (guibutton.field_146127_k == this.stockControlButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(5)));
        } else if (guibutton.field_146127_k == this.fillEmptyButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(4)));
        } else if (guibutton.field_146127_k == this.craftSingleButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2)));
        } else if (guibutton.field_146127_k == this.craftAvailableButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3)));
        } else if (guibutton.field_146127_k == this.autoModeButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0)));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.encodeFormulaButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe && this.canEncode();
        this.stockControlButton.field_146124_l = ((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null;
        this.fillEmptyButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode;
        this.craftSingleButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe;
        this.craftAvailableButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe;
        this.autoModeButton.field_146124_l = ((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFormulaicAssemblicator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFormulaicAssemblicator)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.fillEmptyButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.fillEmpty"), xAxis, yAxis);
        } else if (this.encodeFormulaButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.encodeFormula"), xAxis, yAxis);
        } else if (this.craftSingleButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.craftSingle"), xAxis, yAxis);
        } else if (this.craftAvailableButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.craftAvailable"), xAxis, yAxis);
        } else if (this.autoModeButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.autoModeToggle") + ": " + LangUtils.transOnOff(((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode), xAxis, yAxis);
        } else if (this.stockControlButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.stockControl") + ": " + LangUtils.transOnOff(((TileEntityFormulaicAssemblicator)this.tileEntity).stockControl), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        if (((TileEntityFormulaicAssemblicator)this.tileEntity).operatingTicks > 0) {
            int display = (int)((double)((TileEntityFormulaicAssemblicator)this.tileEntity).operatingTicks * 22.0 / (double)((TileEntityFormulaicAssemblicator)this.tileEntity).ticksRequired);
            this.func_73729_b(this.field_147003_i + 86, this.field_147009_r + 43, 176, 48, display, 16);
        }
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSlot.png"));
        this.func_73729_b(this.field_147003_i + 90, this.field_147009_r + 25, ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe ? 2 : 20, 39, 14, 12);
        if (((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tileEntity).formula.input.get(i);
                if (stack.func_190926_b()) continue;
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i + 20);
                int guiX = this.field_147003_i + slot.field_75223_e;
                int guiY = this.field_147009_r + slot.field_75221_f;
                if (slot.func_75211_c().func_190926_b() || !((TileEntityFormulaicAssemblicator)this.tileEntity).formula.isIngredientInPos(((TileEntityFormulaicAssemblicator)this.tileEntity).func_145831_w(), slot.func_75211_c(), i)) {
                    this.drawColorIcon(guiX, guiY, EnumColor.DARK_RED, 0.8f);
                }
                this.renderItem(stack, guiX, guiY);
            }
        }
    }

    private boolean canEncode() {
        if (((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null) {
            return false;
        }
        ItemStack formulaStack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tileEntity).inventory.get(2);
        return !formulaStack.func_190926_b() && formulaStack.func_77973_b() instanceof ItemCraftingFormula && ((ItemCraftingFormula)formulaStack.func_77973_b()).getInventory(formulaStack) == null;
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiFormulaicAssemblicator.png");
    }
}

