/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.powerchisels;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.chisel.api.IChiselGuiType;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.NBTUtil;
import trinsdar.powerchisels.Config;

public class ItemFluxedChisel
extends Item
implements IChiselItem {
    public static final int MAX_ENERGY = 40000;
    public static final ItemFluxedChisel fluxedChisel = new ItemFluxedChisel();

    public ItemFluxedChisel() {
        this.func_77625_d(1);
        this.setRegistryName("fluxed_chisel");
        this.func_77655_b("powerchisels.fluxedChisel");
        this.func_77637_a(ChiselTabs.tab);
    }

    public boolean func_77662_d() {
        return true;
    }

    public int getCost() {
        return 80;
    }

    public boolean hasEnoughEnergy(ItemStack stack) {
        return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() >= this.getCost();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack empty = new ItemStack((Item)this, 1, 0);
            ItemStack full = new ItemStack((Item)this, 1, 0);
            ((IEnergyStorage)full.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(40000, false);
            ((IEnergyStorage)full.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(40000, false);
            items.add((Object)empty);
            items.add((Object)full);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / 40000.0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List list, ITooltipFlag flag) {
        IEnergyStorage energyStorage;
        String base = "item.chisel.chisel.desc.";
        list.add(I18n.func_135052_a((String)(base + "gui"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add(I18n.func_135052_a((String)(base + "lc1"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add(I18n.func_135052_a((String)(base + "lc2"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add("");
        list.add(I18n.func_135052_a((String)(base + "modes"), (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)(base + "modes.selected"), (Object[])new Object[]{TextFormatting.GREEN + I18n.func_135052_a((String)(NBTUtil.getChiselMode((ItemStack)stack).getUnlocName() + ".name"), (Object[])new Object[0])}));
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            list.add(I18n.func_135052_a((String)(base + "energy"), (Object[])new Object[0]) + ": " + energyStorage.getEnergyStored() + "/" + energyStorage.getMaxEnergyStored() + " FE");
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND && this.hasEnoughEnergy(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Chisel Damage", 2.0, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.hasEnoughEnergy(stack)) {
            this.extractEnergy(stack, this.getCost(), false);
        }
        return super.func_77644_a(stack, attacker, target);
    }

    public boolean canOpenGui(World world, EntityPlayer player, EnumHand hand) {
        return this.hasEnoughEnergy(player.func_184586_b(hand));
    }

    public IChiselGuiType getGuiType(World world, EntityPlayer player, EnumHand hand) {
        return IChiselGuiType.ChiselGuiType.NORMAL;
    }

    public boolean canChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return this.hasEnoughEnergy(chisel);
    }

    public ItemStack craftItem(ItemStack chisel, ItemStack source, ItemStack target, EntityPlayer player) {
        if (chisel.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toCraft = Math.min(source.func_190916_E(), target.func_77976_d());
        if (this.hasEnoughEnergy(chisel)) {
            int damageLeft = this.getEnergyStored(chisel) / this.getCost();
            toCraft = Math.min(toCraft, damageLeft);
            this.extractEnergy(chisel, toCraft * this.getCost(), false);
        }
        ItemStack res = target.func_77946_l();
        source.func_190918_g(toCraft);
        res.func_190920_e(toCraft);
        return res;
    }

    public boolean onChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return true;
    }

    public boolean canChiselBlock(World world, EntityPlayer player, EnumHand hand, BlockPos pos, IBlockState state) {
        return this.hasEnoughEnergy(player.func_184586_b(hand));
    }

    public boolean supportsMode(EntityPlayer player, ItemStack chisel, IChiselMode mode) {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTBase>(){
            EnergyStorage buffer = new EnergyStorage(40000);

            public NBTBase serializeNBT() {
                return CapabilityEnergy.ENERGY.writeNBT((Object)this.buffer, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                CapabilityEnergy.ENERGY.readNBT((Object)this.buffer, null, nbt);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityEnergy.ENERGY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == CapabilityEnergy.ENERGY) {
                    return (T)this.buffer;
                }
                return null;
            }
        };
    }

    public int extractEnergy(ItemStack chisel, int maxExtract, boolean simulate) {
        return ((IEnergyStorage)chisel.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ItemStack stack) {
        return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)fluxedChisel);
    }

    public static void initRecipe() {
        ItemStack chisel = new ItemStack((Item)fluxedChisel);
        if (!Config.defaultFluxedChiselRecipeOverride) {
            if (!Loader.isModLoaded((String)"enderio") && !Loader.isModLoaded((String)"thermalexpansion") && Config.defaultFluxedChiselRecipe) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("fluxedChiselDefault"), null, (ItemStack)chisel, (Object[])new Object[]{"IC", "RI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), ChiselItems.chisel_iron, Character.valueOf('R'), "blockRedstone"});
            }
        } else if (Config.defaultFluxedChiselRecipeOverride && Config.defaultFluxedChiselRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("fluxedChiselDefault"), null, (ItemStack)chisel, (Object[])new Object[]{"IC", "RI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), ChiselItems.chisel_iron, Character.valueOf('R'), "blockRedstone"});
        }
        if (Config.enderIOCompat && Loader.isModLoaded((String)"enderio")) {
            ItemStack capacitor = GameRegistry.makeItemStack((String)"enderio:item_basic_capacitor", (int)0, (int)1, null);
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("fluxedChiselEnderIO"), null, (ItemStack)chisel, (Object[])new Object[]{"Ic", "CI", Character.valueOf('I'), "ingotConductiveIron", Character.valueOf('c'), ChiselItems.chisel_iron, Character.valueOf('C'), capacitor});
        }
        if (Config.thermalCompat && Loader.isModLoaded((String)"thermalexpansion")) {
            ItemStack toolcasing = GameRegistry.makeItemStack((String)"thermalfoundation:material", (int)640, (int)1, null);
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("fluxedChiselThermalExpansion"), null, (ItemStack)chisel, (Object[])new Object[]{"IC", "TI", Character.valueOf('I'), "ingotSilver", Character.valueOf('C'), ChiselItems.chisel_iron, Character.valueOf('T'), toolcasing});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

