/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.powerchisels;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.Recipes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.chisel.api.IChiselGuiType;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.NBTUtil;

public class ItemElectricChisel
extends Item
implements IElectricItem,
IChiselItem {
    public static String classic = "ic2-classic-spmod";
    public static final ItemElectricChisel electricChisel = new ItemElectricChisel();

    public ItemElectricChisel() {
        this.func_77625_d(1);
        this.setRegistryName("electric_chisel");
        this.func_77655_b("powerchisels.electricChisel");
        this.func_77637_a(ChiselTabs.tab);
    }

    public boolean func_77662_d() {
        return true;
    }

    public static boolean isClassicLoaded() {
        return Loader.isModLoaded((String)classic);
    }

    public double getCost(ItemStack stack) {
        return 20.0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack empty = new ItemStack((Item)this, 1, 0);
            ItemStack full = new ItemStack((Item)this, 1, 0);
            ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
            items.add((Object)empty);
            items.add((Object)full);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (ItemElectricChisel.isClassicLoaded()) {
            return true;
        }
        return ElectricItem.manager.getCharge(stack) != this.getMaxCharge(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean canOpenGui(World world, EntityPlayer player, EnumHand hand) {
        return ElectricItem.manager.getCharge(player.func_184586_b(hand)) >= this.getCost(player.func_184586_b(hand));
    }

    public IChiselGuiType getGuiType(World world, EntityPlayer player, EnumHand hand) {
        return IChiselGuiType.ChiselGuiType.NORMAL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List list, ITooltipFlag flag) {
        String base = "item.chisel.chisel.desc.";
        list.add(I18n.func_135052_a((String)(base + "gui"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add(I18n.func_135052_a((String)(base + "lc1"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add(I18n.func_135052_a((String)(base + "lc2"), (Object[])new Object[]{TextFormatting.AQUA, TextFormatting.GRAY}));
        list.add("");
        list.add(I18n.func_135052_a((String)(base + "modes"), (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)(base + "modes.selected"), (Object[])new Object[]{TextFormatting.GREEN + I18n.func_135052_a((String)(NBTUtil.getChiselMode((ItemStack)stack).getUnlocName() + ".name"), (Object[])new Object[0])}));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND && ElectricItem.manager.getCharge(stack) >= this.getCost(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Chisel Damage", 2.0, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (ElectricItem.manager.getCharge(stack) >= this.getCost(stack)) {
            ElectricItem.manager.use(stack, this.getCost(stack), attacker);
        }
        return super.func_77644_a(stack, attacker, target);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean canChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return ElectricItem.manager.getCharge(chisel) >= this.getCost(chisel);
    }

    public ItemStack craftItem(ItemStack chisel, ItemStack source, ItemStack target, EntityPlayer player) {
        if (chisel.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toCraft = Math.min(source.func_190916_E(), target.func_77976_d());
        if (ElectricItem.manager.getCharge(chisel) >= this.getCost(chisel)) {
            int damageLeft = (int)ElectricItem.manager.getCharge(chisel) / (int)this.getCost(chisel);
            toCraft = Math.min(toCraft, damageLeft);
            ElectricItem.manager.use(chisel, (double)toCraft * this.getCost(chisel), (EntityLivingBase)player);
        }
        ItemStack res = target.func_77946_l();
        source.func_190918_g(toCraft);
        res.func_190920_e(toCraft);
        return res;
    }

    public boolean onChisel(World world, EntityPlayer player, ItemStack chisel, ICarvingVariation target) {
        return true;
    }

    public boolean canChiselBlock(World world, EntityPlayer player, EnumHand hand, BlockPos pos, IBlockState state) {
        return ElectricItem.manager.getCharge(player.func_184586_b(hand)) >= this.getCost(player.func_184586_b(hand));
    }

    public boolean supportsMode(EntityPlayer player, ItemStack chisel, IChiselMode mode) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 10000.0;
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 100.0;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)electricChisel);
    }

    public static void initRecipe() {
        if (ItemElectricChisel.isClassicLoaded()) {
            Recipes.advRecipes.addRecipe(new ItemStack((Item)electricChisel), new Object[]{"  I", " C ", "B  ", Character.valueOf('I'), "ingotRefinedIron", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), IC2Items.getItem((String)"charging_re_battery")});
        } else {
            Recipes.advRecipes.addRecipe(new ItemStack((Item)electricChisel), new Object[]{"I ", " S", Character.valueOf('I'), "plateIron", Character.valueOf('S'), IC2Items.getItem((String)"crafting", (String)"small_power_unit")});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

