/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class BlockEditHandler {
    public static final HashMap<Integer, Queue<EditQueue>> worldToRemoveQueue = new HashMap();
    public static float maxTickTimePercentage = 0.7f;

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        if (worldToRemoveQueue.containsKey(dim)) {
            worldToRemoveQueue.remove(dim);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        int dim = event.world.field_73011_w.getDimension();
        if (worldToRemoveQueue.containsKey(dim)) {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + (long)(50.0f * maxTickTimePercentage);
            Queue<EditQueue> list = worldToRemoveQueue.get(dim);
            if (!list.isEmpty()) {
                int limitPerQueue = 50;
                while (System.currentTimeMillis() < endTime && !list.isEmpty()) {
                    EditQueue queue = list.peek();
                    if (queue != null) {
                        queue.doWork(limitPerQueue);
                        if (!queue.queue.isEmpty()) continue;
                        list.poll();
                        continue;
                    }
                    list.poll();
                }
            }
        }
    }

    public static void queue(World world, Collection<BlockPos> edits, Consumer<BlockPos> onEditBlock) {
        BlockEditHandler.queue(world, edits, onEditBlock, null);
    }

    public static void queue(World world, Collection<BlockPos> edits, Consumer<BlockPos> onEditBlock, Runnable onCompleteCallback) {
        int dim = world.field_73011_w.getDimension();
        if (!worldToRemoveQueue.containsKey(dim)) {
            worldToRemoveQueue.put(dim, new LinkedList());
        }
        worldToRemoveQueue.get(dim).add(new EditQueue(edits, onEditBlock, onCompleteCallback));
    }

    public static class EditQueue {
        final Queue<BlockPos> queue = new LinkedList<BlockPos>();
        final Consumer<BlockPos> onEditBlock;
        final Runnable onCompleteCallback;

        public EditQueue(Collection<BlockPos> edits, Consumer<BlockPos> onEditBlock, Runnable onCompleteCallback) {
            this.queue.addAll(edits);
            this.onEditBlock = onEditBlock;
            this.onCompleteCallback = onCompleteCallback;
        }

        void doWork(int limit) {
            for (int editsCount = 0; editsCount <= limit && !this.queue.isEmpty(); ++editsCount) {
                this.onEditBlock.accept(this.queue.poll());
            }
            if (this.queue.isEmpty() && this.onCompleteCallback != null) {
                this.onCompleteCallback.run();
            }
        }
    }
}

