/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blast.Blast;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class ExplosiveHandler {
    public static final ArrayList<IBlast> activeBlasts = new ArrayList();

    public static void add(Blast blast) {
        activeBlasts.add(blast);
    }

    public static void remove(Blast blast) {
        activeBlasts.remove(blast);
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            int dim = event.getWorld().field_73011_w.getDimension();
            activeBlasts.stream().filter(blast -> !blast.hasWorld() || blast.world().field_73011_w.getDimension() == dim).forEach(IBlast::clearBlast);
        }
    }

    public static int removeNear(World world, double x, double y, double z, double range) {
        Pos pos = new Pos(x, y, z);
        List<IBlast> toRemove = activeBlasts.stream().filter(blast -> blast.world() == world).filter(blast -> range < 0.0 || range > 0.0 && range > pos.distance((IPos3D)blast)).collect(Collectors.toList());
        activeBlasts.removeAll(toRemove);
        toRemove.forEach(IBlast::clearBlast);
        return toRemove.size();
    }

    public static BlastState createExplosion(Entity cause, World world, double x, double y, double z, IExplosive capabilityExplosive) {
        if (capabilityExplosive == null || capabilityExplosive.getExplosiveData() == null) {
            ICBMClassic.logger().error("ExplosiveHandler: Missing capability for explosive, cap: " + capabilityExplosive + "  cause: " + cause, (Throwable)new RuntimeException());
            return BlastState.NULL;
        }
        return ExplosiveHandler.createExplosion(cause, world, x, y, z, capabilityExplosive.getExplosiveData().getRegistryID(), 1.0f, capabilityExplosive.getCustomBlastData());
    }

    public static BlastState createExplosion(Entity cause, World world, double x, double y, double z, int blastID, float scale, NBTTagCompound customData) {
        IBlast blast = ExplosiveHandler.createNew(cause, world, x, y, z, blastID, scale, customData);
        if (blast != null) {
            return blast.runBlast();
        }
        return BlastState.NULL;
    }

    public static IBlast createNew(Entity cause, World world, double x, double y, double z, int blastID, float scale, NBTTagCompound customData) {
        IExplosiveData explosiveData = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(blastID);
        return ExplosiveHandler.createNew(cause, world, x, y, z, explosiveData, scale, customData);
    }

    public static IBlast createNew(Entity cause, World world, double x, double y, double z, IExplosiveData data, float scale, NBTTagCompound customData) {
        if (data != null && data.getBlastFactory() != null) {
            IBlastInit blast = data.getBlastFactory().create();
            blast.setBlastWorld(world);
            blast.setBlastPosition(x, y, z);
            blast.scaleBlast(scale);
            blast.setBlastSource(cause);
            blast.setExplosiveData(data);
            return blast.buildBlast();
        }
        ICBMClassic.logger().error("ExplosiveHandler: Failed to create blast, data: " + data + " factory: " + (data != null ? data.getBlastFactory() : " nil"), (Throwable)new RuntimeException());
        return null;
    }
}

