/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.IWorldPosition;
import icbm.classic.api.caps.IMissileLauncher;
import icbm.classic.api.events.RadarGunTraceEvent;
import icbm.classic.api.items.IWorldPosItem;
import icbm.classic.api.tile.multiblock.IMultiTile;
import icbm.classic.api.tile.multiblock.IMultiTileHost;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketPlayerItem;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.prefab.item.ItemBase;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRadarGun
extends ItemBase
implements IWorldPosItem,
IPacketIDReceiver {
    public static final String NBT_LINK_POS = "linkPos";

    public ItemRadarGun() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ICBMClassic.CREATIVE_TAB);
        this.func_77655_b("icbmclassic:radarGun");
        this.setRegistryName("icbmclassic", "radarGun");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        String localization = LanguageUtility.getLocal(this.func_77658_a() + ".info");
        if (localization != null && !localization.isEmpty()) {
            String[] split;
            for (String line : split = localization.split(",")) {
                lines.add(line.trim());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(handIn);
                stack.func_77982_d(null);
                stack.func_77964_b(0);
                LanguageUtility.addChatToPlayer(player, "gps.cleared.name");
                player.field_71069_bz.func_75142_b();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
        }
        if (world.field_72995_K) {
            TileEntity tileEntity;
            RayTraceResult objectMouseOver = player.func_174822_a(200.0, 1.0f);
            if (objectMouseOver.field_72313_a != RayTraceResult.Type.MISS && !ICBMClassicHelpers.isLauncher(tileEntity = world.func_175625_s(objectMouseOver.func_178782_a()), null)) {
                ICBMClassic.packetHandler.sendToServer(new PacketPlayerItem(player).addData(new Object[]{objectMouseOver.func_178782_a()}));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IMultiTileHost host;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Location location = new Location(world, pos);
        TileEntity tile = location.getTileEntity();
        if (tile instanceof IMultiTile && (host = ((IMultiTile)tile).getHost()) instanceof TileEntity) {
            tile = (TileEntity)host;
        }
        if (player.func_70093_af()) {
            stack.func_77982_d(null);
            stack.func_77964_b(0);
            LanguageUtility.addChatToPlayer(player, "gps.cleared.name");
            player.field_71069_bz.func_75142_b();
            return EnumActionResult.SUCCESS;
        }
        Location storedLocation = this.getLocation(stack);
        if (ICBMClassicHelpers.isLauncher(tile, facing)) {
            if (storedLocation == null) {
                LanguageUtility.addChatToPlayer(player, "gps.error.pos.invalid.null.name");
                return EnumActionResult.SUCCESS;
            }
            if (!storedLocation.isAboveBedrock()) {
                LanguageUtility.addChatToPlayer(player, "gps.error.pos.invalid.name");
                return EnumActionResult.SUCCESS;
            }
            if (storedLocation.world != world) {
                LanguageUtility.addChatToPlayer(player, "gps.error.pos.invalid.world.name");
                return EnumActionResult.SUCCESS;
            }
            IMissileLauncher launcher = ICBMClassicHelpers.getLauncher(tile, facing);
            if (launcher != null) {
                launcher.setTarget(storedLocation.x(), storedLocation.y(), storedLocation.z());
                LanguageUtility.addChatToPlayer(player, "gps.data.transferred.name");
                return EnumActionResult.SUCCESS;
            }
        } else if (this.trace(pos, player)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket packet) {
        return this.trace(buf.readInt(), buf.readInt(), buf.readInt(), player);
    }

    public boolean trace(int x, int y, int z, EntityPlayer player) {
        return this.trace(new BlockPos(x, y, z), player);
    }

    public boolean trace(BlockPos pos, EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == this) {
            RadarGunTraceEvent event = new RadarGunTraceEvent(player.field_70170_p, pos, player);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            if (event.pos == null) {
                this.setLocation(stack, new Location(player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            } else {
                this.setLocation(stack, new Location(player.field_70170_p, event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p()));
            }
            LanguageUtility.addChatToPlayer(player, "gps.pos.set.name");
            System.out.println(this.getLocation(stack));
        }
        return true;
    }

    @Override
    public Location getLocation(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(NBT_LINK_POS)) {
            return new Location(stack.func_77978_p().func_74775_l(NBT_LINK_POS));
        }
        return null;
    }

    @Override
    public void setLocation(ItemStack stack, IWorldPosition loc) {
        if (loc != null) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound save = new NBTTagCompound();
            if (loc instanceof Location) {
                ((Location)loc).writeNBT(save);
            } else {
                new Location(loc).writeNBT(save);
            }
            stack.func_77978_p().func_74782_a(NBT_LINK_POS, (NBTBase)save);
        } else if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_82580_o(NBT_LINK_POS);
        }
    }

    @Override
    public boolean canAccessLocation(ItemStack stack, Object obj) {
        return false;
    }
}

