/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.api.data.Int3Consumer;

public class BlastHelpers {
    public static void loopInRadius(double radius, Int3Consumer consumer) {
        BlastHelpers.loopCubeNP((int)Math.ceil(radius), (x, y, z) -> {
            double distanceSQ = x * x + y * y + z * z;
            double radiusSQ = radius * radius;
            if (distanceSQ <= radiusSQ) {
                consumer.apply(x, y, z);
            }
        });
    }

    public static void loopCubeNP(int size, Int3Consumer consumer) {
        BlastHelpers.loopCubeNP(size, size, size, consumer);
    }

    public static void loopCubeNP(int xSize, int ySize, int zSize, Int3Consumer consumer) {
        for (int x = -xSize; x < ySize; ++x) {
            for (int y = -ySize; y < ySize; ++y) {
                for (int z = -zSize; z < zSize; ++z) {
                    consumer.apply(x, y, z);
                }
            }
        }
    }
}

