/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.sub;

import icbm.classic.command.CommandUtils;
import icbm.classic.command.system.SubCommand;
import icbm.classic.content.entity.EntityExplosive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandRemove
extends SubCommand {
    public static final String TRANSLATION_REMOVE = "command.icbmclassic:icbm.remove";

    public CommandRemove() {
        super("remove");
    }

    @Override
    protected void collectHelpForAll(Consumer<String> consumer) {
        consumer.accept("<all/missiles/explosions> <dim> <x> <y> <z> <radius>");
    }

    @Override
    protected void collectHelpWorldOnly(Consumer<String> consumer) {
        consumer.accept("<all/missiles/explosions> [radius]");
    }

    @Override
    public void handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length <= 0 || !this.doCommand(sender, args)) {
            throw new WrongUsageException("command.icbmclassic:icbm.error.unknown.command", new Object[]{this.getUsage(sender)});
        }
    }

    private boolean doCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        double z;
        double y;
        double x;
        World world;
        Predicate<Entity> entitySelector = this.buildSelector(args[0]);
        int range = this.getRange(args);
        if (args.length >= 5) {
            world = CommandUtils.getWorld(sender, args[1], sender.func_130014_f_());
            x = CommandUtils.getNumber(sender, args[2], sender.func_174791_d().field_72450_a);
            y = CommandUtils.getNumber(sender, args[3], sender.func_174791_d().field_72448_b);
            z = CommandUtils.getNumber(sender, args[4], sender.func_174791_d().field_72449_c);
        } else if (!(sender instanceof MinecraftServer) && args.length <= 2) {
            world = sender.func_130014_f_();
            x = sender.func_174791_d().field_72450_a;
            y = sender.func_174791_d().field_72448_b;
            z = sender.func_174791_d().field_72449_c;
        } else {
            return false;
        }
        List<Entity> entities = CommandUtils.getEntities(world, x, y, z, range, entitySelector);
        entities.forEach(Entity::func_70106_y);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TRANSLATION_REMOVE, new Object[]{entities.size(), range}));
        return true;
    }

    private int getRange(String[] args) throws NumberInvalidException {
        if (args.length == 2) {
            return CommandBase.func_175755_a((String)args[1]);
        }
        if (args.length == 6) {
            return CommandBase.func_175755_a((String)args[5]);
        }
        return -1;
    }

    private boolean isRemoveMissile(String type) {
        return type.equalsIgnoreCase("missiles") || type.equalsIgnoreCase("missile");
    }

    private boolean isRemoveExplosion(String type) {
        return type.equalsIgnoreCase("explosions") || type.equalsIgnoreCase("explosion") || type.equalsIgnoreCase("explosive") || type.equalsIgnoreCase("explosives") || type.equalsIgnoreCase("ex");
    }

    private Predicate<Entity> buildSelector(String type) {
        boolean remove_all = type.equalsIgnoreCase("all");
        boolean remove_missiles = this.isRemoveMissile(type);
        boolean remove_explosives = this.isRemoveExplosion(type);
        return entity -> {
            if (entity.func_70089_S()) {
                if (remove_all) {
                    return CommandUtils.isICBMEntity(entity);
                }
                if (remove_explosives) {
                    return entity instanceof EntityExplosive;
                }
                return remove_missiles && CommandUtils.isMissile(entity);
            }
            return false;
        };
    }

    @Override
    public List<String> getTabSuggestions(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])new String[]{"all", "missile", "explosion"}) : new ArrayList<String>();
    }
}

