/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.extracpus.aehacks.client;

import appeng.block.crafting.BlockCraftingUnit;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.crafting.CraftingCubeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

abstract class CraftingStorageModelBaked
implements IBakedModel {
    private final VertexFormat format;
    private final TextureAtlasSprite ringCorner;
    private final TextureAtlasSprite ringHor;
    private final TextureAtlasSprite ringVer;

    CraftingStorageModelBaked(VertexFormat format, TextureAtlasSprite ringCorner, TextureAtlasSprite ringHor, TextureAtlasSprite ringVer) {
        this.format = format;
        this.ringCorner = ringCorner;
        this.ringHor = ringHor;
        this.ringVer = ringVer;
    }

    private static EnumSet<EnumFacing> getConnections(@Nullable IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return EnumSet.noneOf(EnumFacing.class);
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        CraftingCubeState cubeState = (CraftingCubeState)extState.getValue((IUnlistedProperty)BlockCraftingUnit.STATE);
        if (cubeState == null) {
            return EnumSet.noneOf(EnumFacing.class);
        }
        return cubeState.getConnections();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return Collections.emptyList();
        }
        EnumSet<EnumFacing> connections = CraftingStorageModelBaked.getConnections(state);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        CubeBuilder builder = new CubeBuilder(this.format, quads);
        builder.setDrawFaces(EnumSet.of(side));
        this.addRing(builder, side, connections);
        float x2 = connections.contains(EnumFacing.EAST) ? 16.0f : 13.01f;
        float x1 = connections.contains(EnumFacing.WEST) ? 0.0f : 2.99f;
        float y2 = connections.contains(EnumFacing.UP) ? 16.0f : 13.01f;
        float y1 = connections.contains(EnumFacing.DOWN) ? 0.0f : 2.99f;
        float z2 = connections.contains(EnumFacing.SOUTH) ? 16.0f : 13.01f;
        float z1 = connections.contains(EnumFacing.NORTH) ? 0.0f : 2.99f;
        switch (side) {
            case DOWN: 
            case UP: {
                y1 = 0.0f;
                y2 = 16.0f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                z1 = 0.0f;
                z2 = 16.0f;
                break;
            }
            case WEST: 
            case EAST: {
                x1 = 0.0f;
                x2 = 16.0f;
            }
        }
        this.addInnerCube(side, state, builder, x1, y1, z1, x2, y2, z2);
        return quads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.ringCorner;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private void addRing(CubeBuilder builder, EnumFacing side, EnumSet<EnumFacing> connections) {
        builder.setTexture(this.ringCorner);
        this.addCornerCap(builder, connections, side, EnumFacing.UP, EnumFacing.EAST, EnumFacing.NORTH);
        this.addCornerCap(builder, connections, side, EnumFacing.UP, EnumFacing.EAST, EnumFacing.SOUTH);
        this.addCornerCap(builder, connections, side, EnumFacing.UP, EnumFacing.WEST, EnumFacing.NORTH);
        this.addCornerCap(builder, connections, side, EnumFacing.UP, EnumFacing.WEST, EnumFacing.SOUTH);
        this.addCornerCap(builder, connections, side, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.NORTH);
        this.addCornerCap(builder, connections, side, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH);
        this.addCornerCap(builder, connections, side, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.NORTH);
        this.addCornerCap(builder, connections, side, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.SOUTH);
        for (EnumFacing a : EnumFacing.values()) {
            if (a == side || a == side.func_176734_d()) continue;
            if (side.func_176740_k() != EnumFacing.Axis.Y && (a == EnumFacing.NORTH || a == EnumFacing.EAST || a == EnumFacing.WEST || a == EnumFacing.SOUTH)) {
                builder.setTexture(this.ringVer);
            } else if (side.func_176740_k() == EnumFacing.Axis.Y && (a == EnumFacing.EAST || a == EnumFacing.WEST)) {
                builder.setTexture(this.ringVer);
            } else {
                builder.setTexture(this.ringHor);
            }
            if (connections.contains(a)) continue;
            float x1 = 0.0f;
            float y1 = 0.0f;
            float z1 = 0.0f;
            float x2 = 16.0f;
            float y2 = 16.0f;
            float z2 = 16.0f;
            switch (a) {
                case DOWN: {
                    y1 = 0.0f;
                    y2 = 3.0f;
                    break;
                }
                case UP: {
                    y1 = 13.0f;
                    break;
                }
                case WEST: {
                    x1 = 0.0f;
                    x2 = 3.0f;
                    break;
                }
                case EAST: {
                    x1 = 13.0f;
                    break;
                }
                case NORTH: {
                    z1 = 0.0f;
                    z2 = 3.0f;
                    break;
                }
                case SOUTH: {
                    z1 = 13.0f;
                }
            }
            EnumFacing perpendicular = a.func_176732_a(side.func_176740_k());
            for (EnumFacing cornerCandidate : EnumSet.of(perpendicular, perpendicular.func_176734_d())) {
                if (connections.contains(cornerCandidate)) continue;
                switch (cornerCandidate) {
                    case DOWN: {
                        y1 = 3.0f;
                        break;
                    }
                    case UP: {
                        y2 = 13.0f;
                        break;
                    }
                    case NORTH: {
                        z1 = 3.0f;
                        break;
                    }
                    case SOUTH: {
                        z2 = 13.0f;
                        break;
                    }
                    case WEST: {
                        x1 = 3.0f;
                        break;
                    }
                    case EAST: {
                        x2 = 13.0f;
                    }
                }
            }
            builder.addCube(x1, y1, z1, x2, y2, z2);
        }
    }

    private void addCornerCap(CubeBuilder builder, EnumSet<EnumFacing> connections, EnumFacing side, EnumFacing down, EnumFacing west, EnumFacing north) {
        if (connections.contains(down) || connections.contains(west) || connections.contains(north)) {
            return;
        }
        if (side != down && side != west && side != north) {
            return;
        }
        float x1 = west == EnumFacing.WEST ? 0 : 13;
        float y1 = down == EnumFacing.DOWN ? 0 : 13;
        float z1 = north == EnumFacing.NORTH ? 0 : 13;
        float x2 = west == EnumFacing.WEST ? 3 : 16;
        float y2 = down == EnumFacing.DOWN ? 3 : 16;
        float z2 = north == EnumFacing.NORTH ? 3 : 16;
        builder.addCube(x1, y1, z1, x2, y2, z2);
    }

    protected abstract void addInnerCube(EnumFacing var1, @Nullable IBlockState var2, CubeBuilder var3, float var4, float var5, float var6, float var7, float var8, float var9);
}

