/*
 * Decompiled with CFR 0.152.
 */
package ru.lionzxy.aromas3;

import aroma1997.backup.common.notification.IBackupNotification;
import aroma1997.backup.common.storageformat.IBackupInfo;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import io.minio.Result;
import io.minio.messages.DeleteError;
import io.minio.messages.Item;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;
import ru.lionzxy.aromas3.AromaBackupConfig;

public class S3BackupUploader
implements IBackupNotification {
    private static long PART_SIZE = 0xC800000L;
    private Executor executor = Executors.newSingleThreadExecutor();
    private Logger logger;
    private MinioClient client;

    public S3BackupUploader(MinioClient client, Logger logger) throws Exception {
        this.logger = logger;
        this.client = client;
        if (!client.bucketExists(AromaBackupConfig.bucket_name)) {
            client.makeBucket(AromaBackupConfig.bucket_name);
            logger.info("Create bucket " + AromaBackupConfig.bucket_name);
        }
    }

    public void backupCreateEnd(final IBackupInfo info) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                S3BackupUploader.this.uploadBackup(info.getFile());
            }
        });
    }

    private void uploadBackup(File file) {
        this.logger.info("Start uploading file to S3 Storage: " + AromaBackupConfig.url + " bucket " + AromaBackupConfig.bucket_name);
        String newFileName = System.currentTimeMillis() + "-" + file.getName();
        this.logger.info("With name: " + newFileName + " from " + file.getAbsolutePath());
        PutObjectOptions putObjectOptions = new PutObjectOptions(file.length(), PART_SIZE);
        try {
            this.client.putObject(AromaBackupConfig.bucket_name, newFileName, file.getAbsolutePath(), putObjectOptions);
        }
        catch (Exception ex) {
            this.logger.error("Failed upload file to S3 storage", (Throwable)ex);
            return;
        }
        this.logger.info("Upload to S3 Storage successful!");
        if (AromaBackupConfig.keep_latest > 0) {
            try {
                ArrayList objects = new ArrayList();
                ArrayList<String> remove = new ArrayList<String>();
                this.client.listObjects(AromaBackupConfig.bucket_name).forEach(objects::add);
                for (int i = objects.size() - AromaBackupConfig.keep_latest - 1; i >= 0; --i) {
                    remove.add(((Item)((Result)objects.get(i)).get()).objectName());
                }
                int failed = 0;
                for (Result<DeleteError> result : this.client.removeObjects(AromaBackupConfig.bucket_name, remove)) {
                    this.logger.error(String.format("Failed deleting old backup %s", result.get().objectName()));
                    ++failed;
                }
                this.logger.info(String.format("Deleted %d old backup object(s)", remove.size() - failed));
            }
            catch (Exception ex) {
                this.logger.error("Failed deleting oldest backup objects", (Throwable)ex);
            }
        }
        if (AromaBackupConfig.delete_after_upload) {
            if (file.delete()) {
                this.logger.info("Delete local backup file " + file.getAbsolutePath() + " successful");
            } else {
                this.logger.error("Delete local backup file " + file.getAbsolutePath() + " unsuccessful");
            }
        }
    }
}

