/*
 * Decompiled with CFR 0.152.
 */
package ru.lionzxy.aromas3;

import aroma1997.backup.common.notification.IBackupNotification;
import aroma1997.backup.common.notification.NotificationHelper;
import io.minio.MinioClient;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import ru.lionzxy.aromas3.AromaBackupConfig;
import ru.lionzxy.aromas3.S3BackupUploader;

@Mod(modid="aromabackups3", name="Aroma Backup S3", version="1.2", dependencies="required-after:aromabackup", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class AromaBackupS3 {
    public static final String MODID = "aromabackups3";
    public static final String NAME = "Aroma Backup S3";
    public static final String VERSION = "1.2";
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!AromaBackupConfig.enable) {
            logger.info("Upload to S3 storage DISABLED");
            return;
        }
        logger.info("Upload to S3 storage ENABLED");
        try {
            this.initListener();
        }
        catch (Exception ex) {
            logger.error("Failed init backup listener and S3 storage", (Throwable)ex);
        }
    }

    private void initListener() throws Exception {
        MinioClient minioClient = new MinioClient(AromaBackupConfig.url, AromaBackupConfig.access_key, AromaBackupConfig.secret_key);
        NotificationHelper.INSTANCE.registerNotification((IBackupNotification)new S3BackupUploader(minioClient, logger));
    }
}

